/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.server.DruidNode;

public class ListeningNodeSupplier
implements Supplier<Iterable<DruidNode>> {
    private final List<NodeRole> nodeTypes;
    private final DruidNodeDiscoveryProvider discoveryProvider;

    public ListeningNodeSupplier(List<NodeRole> nodeTypes, DruidNodeDiscoveryProvider discoveryProvider) {
        this.nodeTypes = nodeTypes;
        this.discoveryProvider = discoveryProvider;
    }

    @Override
    public Iterable<DruidNode> get() {
        ArrayList<DruidNode> druidNodes = new ArrayList<DruidNode>();
        for (NodeRole nodeRole : this.nodeTypes) {
            DruidNodeDiscovery nodeDiscovery = this.discoveryProvider.getForNodeRole(nodeRole);
            Collection nodes = nodeDiscovery.getAllNodes();
            nodes.forEach(node -> druidNodes.add(node.getDruidNode()));
        }
        return druidNodes;
    }
}

