/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisfirehose.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisfirehose.model.DeliveryStreamEncryptionStatus;
import com.amazonaws.services.kinesisfirehose.model.FailureDescription;
import com.amazonaws.services.kinesisfirehose.model.KeyType;
import com.amazonaws.services.kinesisfirehose.model.transform.DeliveryStreamEncryptionConfigurationMarshaller;
import java.io.Serializable;

public class DeliveryStreamEncryptionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String keyARN;
    private String keyType;
    private String status;
    private FailureDescription failureDescription;

    public void setKeyARN(String keyARN) {
        this.keyARN = keyARN;
    }

    public String getKeyARN() {
        return this.keyARN;
    }

    public DeliveryStreamEncryptionConfiguration withKeyARN(String keyARN) {
        this.setKeyARN(keyARN);
        return this;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public DeliveryStreamEncryptionConfiguration withKeyType(String keyType) {
        this.setKeyType(keyType);
        return this;
    }

    public DeliveryStreamEncryptionConfiguration withKeyType(KeyType keyType) {
        this.keyType = keyType.toString();
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public DeliveryStreamEncryptionConfiguration withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public DeliveryStreamEncryptionConfiguration withStatus(DeliveryStreamEncryptionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setFailureDescription(FailureDescription failureDescription) {
        this.failureDescription = failureDescription;
    }

    public FailureDescription getFailureDescription() {
        return this.failureDescription;
    }

    public DeliveryStreamEncryptionConfiguration withFailureDescription(FailureDescription failureDescription) {
        this.setFailureDescription(failureDescription);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyARN() != null) {
            sb.append("KeyARN: ").append(this.getKeyARN()).append(",");
        }
        if (this.getKeyType() != null) {
            sb.append("KeyType: ").append(this.getKeyType()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getFailureDescription() != null) {
            sb.append("FailureDescription: ").append(this.getFailureDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeliveryStreamEncryptionConfiguration)) {
            return false;
        }
        DeliveryStreamEncryptionConfiguration other = (DeliveryStreamEncryptionConfiguration)obj;
        if (other.getKeyARN() == null ^ this.getKeyARN() == null) {
            return false;
        }
        if (other.getKeyARN() != null && !other.getKeyARN().equals(this.getKeyARN())) {
            return false;
        }
        if (other.getKeyType() == null ^ this.getKeyType() == null) {
            return false;
        }
        if (other.getKeyType() != null && !other.getKeyType().equals(this.getKeyType())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getFailureDescription() == null ^ this.getFailureDescription() == null) {
            return false;
        }
        return other.getFailureDescription() == null || other.getFailureDescription().equals(this.getFailureDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyARN() == null ? 0 : this.getKeyARN().hashCode());
        hashCode = 31 * hashCode + (this.getKeyType() == null ? 0 : this.getKeyType().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getFailureDescription() == null ? 0 : this.getFailureDescription().hashCode());
        return hashCode;
    }

    public DeliveryStreamEncryptionConfiguration clone() {
        try {
            return (DeliveryStreamEncryptionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeliveryStreamEncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

