/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.appenderator;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.common.actions.RetrieveSegmentsByIdAction;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.realtime.appenderator.PublishedSegmentRetriever;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

public class ActionBasedPublishedSegmentRetriever
implements PublishedSegmentRetriever {
    private static final Logger log = new Logger(ActionBasedPublishedSegmentRetriever.class);
    private final TaskActionClient taskActionClient;

    public ActionBasedPublishedSegmentRetriever(TaskActionClient taskActionClient) {
        this.taskActionClient = taskActionClient;
    }

    public Set<DataSegment> findPublishedSegments(Set<SegmentId> segmentIds) throws IOException {
        if (segmentIds == null || segmentIds.isEmpty()) {
            return Collections.emptySet();
        }
        String dataSource = segmentIds.iterator().next().getDataSource();
        for (SegmentId segmentId : segmentIds) {
            if (segmentId.getDataSource().equals(dataSource)) continue;
            throw InvalidInput.exception((String)"Published segment IDs to find cannot belong to multiple datasources[%s, %s].", (Object[])new Object[]{dataSource, segmentId.getDataSource()});
        }
        Set<String> serializedSegmentIds = segmentIds.stream().map(SegmentId::toString).collect(Collectors.toSet());
        try {
            return this.taskActionClient.submit(new RetrieveSegmentsByIdAction(dataSource, serializedSegmentIds));
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Could not retrieve published segment IDs[%s] using task action[retrieveSegmentsById]. Overlord maybe on an older version, retrying with action[segmentListUsed]. This task may fail to publish segments if there is a concurrent replace happening.", new Object[]{serializedSegmentIds});
            HashSet<DataSegment> publishedSegments = new HashSet<DataSegment>();
            List usedSearchIntervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform(segmentIds, SegmentId::getInterval));
            Collection<DataSegment> foundUsedSegments = this.taskActionClient.submit(new RetrieveUsedSegmentsAction(dataSource, usedSearchIntervals, Segments.INCLUDING_OVERSHADOWED));
            for (DataSegment segment : foundUsedSegments) {
                if (!segmentIds.contains(segment.getId())) continue;
                publishedSegments.add(segment);
            }
            return publishedSegments;
        }
    }
}

