/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Counters {
    public static <K> int getAndIncrementInt(ConcurrentHashMap<K, AtomicInteger> counters, K key) {
        AtomicInteger counter = counters.get(key);
        if (counter == null) {
            counter = counters.computeIfAbsent(key, k -> new AtomicInteger());
        }
        return counter.getAndIncrement();
    }

    public static <K> long incrementAndGetLong(ConcurrentHashMap<K, AtomicLong> counters, K key) {
        AtomicLong counter = counters.get(key);
        if (counter == null) {
            counter = counters.computeIfAbsent(key, k -> new AtomicLong());
        }
        return counter.incrementAndGet();
    }

    private Counters() {
    }
}

