/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.indexer.report.SingleFileTaskReportFileWriter;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexer.report.TaskReportFileWriter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class MultipleFileTaskReportFileWriter
implements TaskReportFileWriter {
    private static final Logger log = new Logger(MultipleFileTaskReportFileWriter.class);
    private final Map<String, File> taskReportFiles = new HashMap<String, File>();
    private ObjectMapper objectMapper;

    public void write(String taskId, TaskReport.ReportMap reports) {
        try (OutputStream outputStream = this.openReportOutputStream(taskId);){
            SingleFileTaskReportFileWriter.writeReportToStream((ObjectMapper)this.objectMapper, (OutputStream)outputStream, (TaskReport.ReportMap)reports);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in write().", new Object[0]);
        }
    }

    public OutputStream openReportOutputStream(String taskId) throws IOException {
        File reportsFile = this.taskReportFiles.get(taskId);
        if (reportsFile == null) {
            throw new ISE("Could not find report file for task[%s]", new Object[]{taskId});
        }
        File reportsFileParent = reportsFile.getParentFile();
        if (reportsFileParent != null) {
            FileUtils.mkdirp((File)reportsFileParent);
        }
        return Files.newOutputStream(reportsFile.toPath(), new OpenOption[0]);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void add(String taskId, File reportsFile) {
        this.taskReportFiles.put(taskId, reportsFile);
    }

    public void delete(String taskId) {
        this.taskReportFiles.remove(taskId);
    }
}

