/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.function.Function;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.guice.annotations.AttemptId;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Parent;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.indexer.report.TaskReportFileWriter;
import org.apache.druid.indexing.common.SegmentCacheManagerFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.indexing.common.task.batch.parallel.ShuffleClient;
import org.apache.druid.indexing.worker.shuffle.IntermediaryDataManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9Factory;
import org.apache.druid.segment.handoff.SegmentHandoffNotifierFactory;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.ChatHandlerProvider;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.tasklogs.TaskLogPusher;
import org.apache.druid.utils.RuntimeInfo;

public class TaskToolboxFactory {
    private final SegmentLoaderConfig segmentLoaderConfig;
    private final TaskConfig config;
    private final DruidNode taskExecutorNode;
    private final TaskActionClientFactory taskActionClientFactory;
    private final ServiceEmitter emitter;
    private final PolicyEnforcer policyEnforcer;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    private final Provider<DruidProcessingConfig> processingConfigProvider;
    private final QueryProcessingPool queryProcessingPool;
    private final JoinableFactory joinableFactory;
    private final Provider<MonitorScheduler> monitorSchedulerProvider;
    private final SegmentCacheManagerFactory segmentCacheManagerFactory;
    private final ObjectMapper jsonMapper;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final IndexMergerV9Factory indexMergerV9Factory;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;
    private final TaskReportFileWriter taskReportFileWriter;
    private final AuthorizerMapper authorizerMapper;
    private final ChatHandlerProvider chatHandlerProvider;
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    private final AppenderatorsManager appenderatorsManager;
    private final OverlordClient overlordClient;
    private final CoordinatorClient coordinatorClient;
    private final IntermediaryDataManager intermediaryDataManager;
    private final ParallelIndexSupervisorTaskClientProvider supervisorTaskClientProvider;
    private final ShuffleClient shuffleClient;
    private final TaskLogPusher taskLogPusher;
    private final String attemptId;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;
    private final RuntimeInfo runtimeInfo;

    @Inject
    public TaskToolboxFactory(SegmentLoaderConfig segmentLoadConfig, TaskConfig config, @Parent DruidNode taskExecutorNode, TaskActionClientFactory taskActionClientFactory, ServiceEmitter emitter, PolicyEnforcer policyEnforcer, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, Provider<DruidProcessingConfig> processingConfigProvider, QueryProcessingPool queryProcessingPool, JoinableFactory joinableFactory, Provider<MonitorScheduler> monitorSchedulerProvider, SegmentCacheManagerFactory segmentCacheManagerFactory, @Json ObjectMapper jsonMapper, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, IndexMergerV9Factory indexMergerV9Factory, DruidNodeAnnouncer druidNodeAnnouncer, @RemoteChatHandler DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService, TaskReportFileWriter taskReportFileWriter, IntermediaryDataManager intermediaryDataManager, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory, AppenderatorsManager appenderatorsManager, OverlordClient overlordClient, CoordinatorClient coordinatorClient, ParallelIndexSupervisorTaskClientProvider supervisorTaskClientProvider, ShuffleClient shuffleClient, TaskLogPusher taskLogPusher, @AttemptId String attemptId, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig, RuntimeInfo runtimeInfo) {
        this.segmentLoaderConfig = segmentLoadConfig;
        this.config = config;
        this.taskExecutorNode = taskExecutorNode;
        this.taskActionClientFactory = taskActionClientFactory;
        this.emitter = emitter;
        this.policyEnforcer = policyEnforcer;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.processingConfigProvider = processingConfigProvider;
        this.queryProcessingPool = queryProcessingPool;
        this.joinableFactory = joinableFactory;
        this.monitorSchedulerProvider = monitorSchedulerProvider;
        this.segmentCacheManagerFactory = segmentCacheManagerFactory;
        this.jsonMapper = jsonMapper;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.indexMergerV9Factory = indexMergerV9Factory;
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
        this.taskReportFileWriter = taskReportFileWriter;
        this.intermediaryDataManager = intermediaryDataManager;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.appenderatorsManager = appenderatorsManager;
        this.overlordClient = overlordClient;
        this.coordinatorClient = coordinatorClient;
        this.supervisorTaskClientProvider = supervisorTaskClientProvider;
        this.shuffleClient = shuffleClient;
        this.taskLogPusher = taskLogPusher;
        this.attemptId = attemptId;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.runtimeInfo = runtimeInfo;
    }

    public TaskToolbox build(Task task) {
        return this.build(this.config, task);
    }

    public TaskToolbox build(Function<TaskConfig, TaskConfig> decoratorFn, Task task) {
        return this.build(decoratorFn.apply(this.config), task);
    }

    public TaskToolbox build(TaskConfig config, Task task) {
        File taskWorkDir = config.getTaskWorkDir(task.getId());
        return new TaskToolbox.Builder().config(config).config(this.segmentLoaderConfig).taskExecutorNode(this.taskExecutorNode).taskActionClient(this.taskActionClientFactory.create(task)).emitter(this.emitter).policyEnforcer(this.policyEnforcer).segmentPusher(this.segmentPusher).dataSegmentKiller(this.dataSegmentKiller).dataSegmentMover(this.dataSegmentMover).dataSegmentArchiver(this.dataSegmentArchiver).segmentAnnouncer(this.segmentAnnouncer).serverAnnouncer(this.serverAnnouncer).handoffNotifierFactory(this.handoffNotifierFactory).queryRunnerFactoryConglomerateProvider(this.queryRunnerFactoryConglomerateProvider).processingConfigProvider(this.processingConfigProvider).queryProcessingPool(this.queryProcessingPool).joinableFactory(this.joinableFactory).monitorSchedulerProvider(this.monitorSchedulerProvider).segmentCacheManager(this.segmentCacheManagerFactory.manufacturate(taskWorkDir)).jsonMapper(this.jsonMapper).taskWorkDir(taskWorkDir).indexIO(this.indexIO).cache(this.cache).cacheConfig(this.cacheConfig).cachePopulatorStats(this.cachePopulatorStats).indexMergerV9(this.indexMergerV9Factory.create(task.getContextValue("storeEmptyColumns", config.isStoreEmptyColumns()).booleanValue())).druidNodeAnnouncer(this.druidNodeAnnouncer).druidNode(this.druidNode).lookupNodeService(this.lookupNodeService).dataNodeService(this.dataNodeService).taskReportFileWriter(this.taskReportFileWriter).intermediaryDataManager(this.intermediaryDataManager).authorizerMapper(this.authorizerMapper).chatHandlerProvider(this.chatHandlerProvider).rowIngestionMetersFactory(this.rowIngestionMetersFactory).appenderatorsManager(this.appenderatorsManager).overlordClient(this.overlordClient.withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.aboutAnHour())).coordinatorClient(this.coordinatorClient.withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.aboutAnHour())).supervisorTaskClientProvider(this.supervisorTaskClientProvider).shuffleClient(this.shuffleClient).taskLogPusher(this.taskLogPusher).attemptId(this.attemptId).centralizedTableSchemaConfig(this.centralizedDatasourceSchemaConfig).runtimeInfo(this.runtimeInfo).build();
    }
}

