/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.joda.time.Duration;
import org.joda.time.Period;

public class TaskQueueConfig {
    @JsonProperty
    private int maxSize;
    @JsonProperty
    private Duration startDelay;
    @JsonProperty
    private Duration restartDelay;
    @JsonProperty
    private Duration storageSyncRate;
    @JsonProperty
    private int taskCompleteHandlerNumThreads;
    @JsonProperty
    private HumanReadableBytes maxTaskPayloadSize;

    @JsonCreator
    public TaskQueueConfig(@JsonProperty(value="maxSize") Integer maxSize, @JsonProperty(value="startDelay") Period startDelay, @JsonProperty(value="restartDelay") Period restartDelay, @JsonProperty(value="storageSyncRate") Period storageSyncRate, @JsonProperty(value="taskCompleteHandlerNumThreads") Integer taskCompleteHandlerNumThreads, @JsonProperty(value="maxTaskPayloadSize") @Nullable HumanReadableBytes maxTaskPayloadSize) {
        this.maxSize = Configs.valueOrDefault((Integer)maxSize, (int)Integer.MAX_VALUE);
        this.taskCompleteHandlerNumThreads = Configs.valueOrDefault((Integer)taskCompleteHandlerNumThreads, (int)5);
        this.startDelay = TaskQueueConfig.defaultDuration(startDelay, "PT1M");
        this.restartDelay = TaskQueueConfig.defaultDuration(restartDelay, "PT30S");
        this.storageSyncRate = TaskQueueConfig.defaultDuration(storageSyncRate, "PT1M");
        this.maxTaskPayloadSize = maxTaskPayloadSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getTaskCompleteHandlerNumThreads() {
        return this.taskCompleteHandlerNumThreads;
    }

    public Duration getStartDelay() {
        return this.startDelay;
    }

    public Duration getRestartDelay() {
        return this.restartDelay;
    }

    public Duration getStorageSyncRate() {
        return this.storageSyncRate;
    }

    public HumanReadableBytes getMaxTaskPayloadSize() {
        return this.maxTaskPayloadSize;
    }

    private static Duration defaultDuration(Period period, String theDefault) {
        return (period == null ? new Period((Object)theDefault) : period).toStandardDuration();
    }
}

