/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.supervisor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditManager;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.http.security.SupervisorResourceFilter;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.utils.CollectionUtils;

@Path(value="/druid/indexer/v1/supervisor")
public class SupervisorResource {
    private static final Function<VersionedSupervisorSpec, Iterable<ResourceAction>> SPEC_DATASOURCE_READ_RA_GENERATOR = supervisorSpec -> {
        if (supervisorSpec.getSpec() == null) {
            return null;
        }
        if (supervisorSpec.getSpec().getDataSources() == null) {
            return new ArrayList();
        }
        return Iterables.transform((Iterable)supervisorSpec.getSpec().getDataSources(), (Function)AuthorizationUtils.DATASOURCE_READ_RA_GENERATOR);
    };
    private final TaskMaster taskMaster;
    private final AuthorizerMapper authorizerMapper;
    private final ObjectMapper objectMapper;
    private final AuditManager auditManager;
    private final AuthConfig authConfig;

    @Inject
    public SupervisorResource(TaskMaster taskMaster, AuthorizerMapper authorizerMapper, ObjectMapper objectMapper, AuthConfig authConfig, AuditManager auditManager) {
        this.taskMaster = taskMaster;
        this.authorizerMapper = authorizerMapper;
        this.objectMapper = objectMapper;
        this.authConfig = authConfig;
        this.auditManager = auditManager;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response specPost(SupervisorSpec spec, @QueryParam(value="skipRestartIfUnmodified") Boolean skipRestartIfUnmodified, @Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Set<ResourceAction> resourceActions;
            Preconditions.checkArgument((!CollectionUtils.isNullOrEmpty((Collection)spec.getDataSources()) ? 1 : 0) != 0, (Object)"No dataSources found to perform authorization checks");
            try {
                resourceActions = this.getNeededResourceActionsForTask(spec);
            }
            catch (UOE e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)e.getMessage())).build();
            }
            AuthorizationResult authResult = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)req, resourceActions, (AuthorizerMapper)this.authorizerMapper);
            if (!authResult.allowAccessWithNoRestriction()) {
                throw new ForbiddenException(authResult.getErrorMessage());
            }
            if (Boolean.TRUE.equals(skipRestartIfUnmodified) && !manager.shouldUpdateSupervisor(spec)) {
                return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)spec.getId())).build();
            }
            manager.createOrUpdateAndStartSupervisor(spec);
            String auditPayload = StringUtils.format((String)"Update supervisor[%s] for datasource[%s]", (Object[])new Object[]{spec.getId(), spec.getDataSources()});
            this.auditManager.doAudit(AuditEntry.builder().key(spec.getId()).type("supervisor").auditInfo(AuthorizationUtils.buildAuditInfo((HttpServletRequest)req)).request(AuthorizationUtils.buildRequestInfo((String)"overlord", (HttpServletRequest)req)).payload((Object)auditPayload).build());
            return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)spec.getId())).build();
        }));
    }

    private Set<ResourceAction> getNeededResourceActionsForTask(SupervisorSpec spec) {
        Set<ResourceAction> resourceActions = spec.getDataSources().stream().map(dataSource -> new ResourceAction(new Resource(dataSource, "DATASOURCE"), Action.WRITE)).collect(Collectors.toSet());
        if (this.authConfig.isEnableInputSourceSecurity()) {
            resourceActions.addAll(spec.getInputSourceResources());
        }
        return resourceActions;
    }

    @GET
    @Produces(value={"application/json"})
    public Response specGetAll(@QueryParam(value="full") String full, @QueryParam(value="state") Boolean state, @QueryParam(value="system") String system, @Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            boolean includeSystem;
            Set<String> authorizedSupervisorIds = this.filterAuthorizedSupervisorIds(req, (SupervisorManager)manager, (Collection<String>)manager.getSupervisorIds());
            boolean includeFull = full != null;
            boolean includeState = state != null && state != false;
            boolean bl = includeSystem = system != null;
            if (includeFull || includeState || includeSystem) {
                List allStates = authorizedSupervisorIds.stream().map(x -> {
                    Optional<SupervisorSpec> theSpec;
                    Optional<SupervisorStateManager.State> theState = manager.getSupervisorState((String)x);
                    SupervisorStatus.Builder theBuilder = new SupervisorStatus.Builder();
                    theBuilder.withId(x);
                    if (theState.isPresent()) {
                        theBuilder.withState(((SupervisorStateManager.State)theState.get()).getBasicState().toString()).withDetailedState(((SupervisorStateManager.State)theState.get()).toString()).withHealthy(((SupervisorStateManager.State)theState.get()).isHealthy());
                    }
                    if ((theSpec = manager.getSupervisorSpec((String)x)).isPresent()) {
                        SupervisorSpec spec = (SupervisorSpec)theSpec.get();
                        theBuilder.withDataSource((String)spec.getDataSources().stream().findFirst().orElse(null));
                        if (includeFull) {
                            theBuilder.withSpec(spec);
                        }
                        if (includeSystem) {
                            try {
                                theBuilder.withSpecString(this.objectMapper.writeValueAsString((Object)spec));
                            }
                            catch (JsonProcessingException e) {
                                throw new RuntimeException(e);
                            }
                            theBuilder.withType(spec.getType()).withSource(spec.getSource()).withSuspended(spec.isSuspended());
                        }
                    }
                    return theBuilder.build();
                }).filter(Objects::nonNull).collect(Collectors.toList());
                return Response.ok(allStates).build();
            }
            return Response.ok(authorizedSupervisorIds).build();
        }));
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specGet(@PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Optional<SupervisorSpec> spec = manager.getSupervisorSpec(id);
            if (!spec.isPresent()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
            }
            return Response.ok((Object)spec.get()).build();
        }));
    }

    @GET
    @Path(value="/{id}/status")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specGetStatus(@PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Optional<SupervisorReport> spec = manager.getSupervisorStatus(id);
            if (!spec.isPresent()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
            }
            return Response.ok((Object)spec.get()).build();
        }));
    }

    @GET
    @Path(value="/{id}/health")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specGetHealth(@PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Optional<Boolean> healthy = manager.isSupervisorHealthy(id);
            if (!healthy.isPresent()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist or health check not implemented", (Object[])new Object[]{id}))).build();
            }
            return Response.status((Response.Status)((Boolean)healthy.get() != false ? Response.Status.OK : Response.Status.SERVICE_UNAVAILABLE)).entity((Object)ImmutableMap.of((Object)"healthy", (Object)((Boolean)healthy.get()))).build();
        }));
    }

    @GET
    @Path(value="/{id}/stats")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response getAllTaskStats(@PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Optional<Map<String, Map<String, Object>>> stats = manager.getSupervisorStats(id);
            if (!stats.isPresent()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
            }
            return Response.ok((Object)stats.get()).build();
        }));
    }

    @GET
    @Path(value="/{id}/parseErrors")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response getAllTaskParseErrors(@PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Optional<List<ParseExceptionReport>> parseErrors = manager.getSupervisorParseErrors(id);
            if (!parseErrors.isPresent()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
            }
            return Response.ok((Object)parseErrors.get()).build();
        }));
    }

    @POST
    @Path(value="/{id}/resume")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specResume(@PathParam(value="id") String id) {
        return this.specSuspendOrResume(id, false);
    }

    @POST
    @Path(value="/{id}/suspend")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response specSuspend(@PathParam(value="id") String id) {
        return this.specSuspendOrResume(id, true);
    }

    @Deprecated
    @POST
    @Path(value="/{id}/shutdown")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response shutdown(@PathParam(value="id") String id) {
        return this.terminate(id);
    }

    @POST
    @Path(value="/{id}/taskGroups/handoff")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response handoffTaskGroups(@PathParam(value="id") String id, @Nonnull HandoffTaskGroupsRequest handoffTaskGroupsRequest) {
        List<Integer> taskGroupIds = handoffTaskGroupsRequest.getTaskGroupIds();
        if (CollectionUtils.isNullOrEmpty(taskGroupIds)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)"List of task groups to handoff can't be empty")).build();
        }
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            try {
                if (manager.handoffTaskGroupsEarly(id, taskGroupIds)) {
                    return Response.ok().build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"Supervisor was not found [%s]", (Object[])new Object[]{id}))).build();
            }
            catch (NotImplementedException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"Supervisor [%s] does not support early handoff", (Object[])new Object[]{id}))).build();
            }
        }));
    }

    @POST
    @Path(value="/{id}/terminate")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response terminate(@PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            if (manager.stopAndRemoveSupervisor(id)) {
                return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)id)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
        }));
    }

    @POST
    @Path(value="/suspendAll")
    @Produces(value={"application/json"})
    public Response suspendAll(@Context HttpServletRequest req) {
        return this.suspendOrResumeAll(req, true);
    }

    @POST
    @Path(value="/resumeAll")
    @Produces(value={"application/json"})
    public Response resumeAll(@Context HttpServletRequest req) {
        return this.suspendOrResumeAll(req, false);
    }

    @POST
    @Path(value="/terminateAll")
    @Produces(value={"application/json"})
    public Response terminateAll(@Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Set<String> authorizedSupervisorIds = this.filterAuthorizedSupervisorIds(req, (SupervisorManager)manager, (Collection<String>)manager.getSupervisorIds());
            for (String supervisorId : authorizedSupervisorIds) {
                manager.stopAndRemoveSupervisor(supervisorId);
            }
            return Response.ok((Object)ImmutableMap.of((Object)"status", (Object)"success")).build();
        }));
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    public Response specGetAllHistory(@Context HttpServletRequest req) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> Response.ok((Object)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, manager.getSupervisorHistory(), SPEC_DATASOURCE_READ_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper)).build()));
    }

    @GET
    @Path(value="/{id}/history")
    @Produces(value={"application/json"})
    public Response specGetHistory(@Context HttpServletRequest req, @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            ArrayList authorizedHistoryForId;
            List<VersionedSupervisorSpec> historyForId = manager.getSupervisorHistoryForId(id);
            if (!historyForId.isEmpty() && !(authorizedHistoryForId = Lists.newArrayList((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, historyForId, SPEC_DATASOURCE_READ_RA_GENERATOR, (AuthorizerMapper)this.authorizerMapper))).isEmpty()) {
                return Response.ok((Object)authorizedHistoryForId).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"No history for [%s].", (Object[])new Object[]{id}))).build();
        }));
    }

    @POST
    @Path(value="/{id}/reset")
    @Produces(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response reset(@PathParam(value="id") String id) {
        return this.handleResetRequest(id, null);
    }

    @POST
    @Path(value="/{id}/resetOffsets")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResourceFilters(value={SupervisorResourceFilter.class})
    public Response resetOffsets(@PathParam(value="id") String id, DataSourceMetadata resetDataSourceMetadata) {
        return this.handleResetRequest(id, resetDataSourceMetadata);
    }

    private Response handleResetRequest(String id, @Nullable DataSourceMetadata resetDataSourceMetadata) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            if (manager.resetSupervisor(id, resetDataSourceMetadata)) {
                return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)id)).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id}))).build();
        }));
    }

    private Response asLeaderWithSupervisorManager(Function<SupervisorManager, Response> f) {
        Optional<SupervisorManager> supervisorManager = this.taskMaster.getSupervisorManager();
        if (supervisorManager.isPresent()) {
            return (Response)f.apply((Object)((SupervisorManager)supervisorManager.get()));
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    private Set<String> filterAuthorizedSupervisorIds(HttpServletRequest req, SupervisorManager manager, Collection<String> supervisorIds) {
        Function raGenerator = supervisorId -> {
            Optional<SupervisorSpec> supervisorSpecOptional = manager.getSupervisorSpec((String)supervisorId);
            if (supervisorSpecOptional.isPresent()) {
                return Iterables.transform((Iterable)((SupervisorSpec)supervisorSpecOptional.get()).getDataSources(), (Function)AuthorizationUtils.DATASOURCE_WRITE_RA_GENERATOR);
            }
            return null;
        };
        return Sets.newHashSet((Iterable)AuthorizationUtils.filterAuthorizedResources((HttpServletRequest)req, supervisorIds, (Function)raGenerator, (AuthorizerMapper)this.authorizerMapper));
    }

    private Response specSuspendOrResume(String id, boolean suspend) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            String errMsg;
            Response.Status status;
            if (manager.suspendOrResumeSupervisor(id, suspend)) {
                Optional<SupervisorSpec> spec = manager.getSupervisorSpec(id);
                return Response.ok((Object)spec.get()).build();
            }
            Optional<SupervisorSpec> spec = manager.getSupervisorSpec(id);
            if (spec.isPresent()) {
                status = Response.Status.BAD_REQUEST;
                errMsg = StringUtils.format((String)"[%s] is already %s", (Object[])new Object[]{id, suspend ? "suspended" : "running"});
            } else {
                status = Response.Status.NOT_FOUND;
                errMsg = StringUtils.format((String)"[%s] does not exist", (Object[])new Object[]{id});
            }
            return Response.status((Response.Status)status).entity((Object)ImmutableMap.of((Object)"error", (Object)errMsg)).build();
        }));
    }

    private Response suspendOrResumeAll(HttpServletRequest req, boolean suspend) {
        return this.asLeaderWithSupervisorManager((Function<SupervisorManager, Response>)((Function)manager -> {
            Set<String> authorizedSupervisorIds = this.filterAuthorizedSupervisorIds(req, (SupervisorManager)manager, (Collection<String>)manager.getSupervisorIds());
            for (String supervisorId : authorizedSupervisorIds) {
                manager.suspendOrResumeSupervisor(supervisorId, suspend);
            }
            return Response.ok((Object)ImmutableMap.of((Object)"status", (Object)"success")).build();
        }));
    }

    public static class HandoffTaskGroupsRequest {
        private final List<Integer> taskGroupIds;

        @JsonCreator
        public HandoffTaskGroupsRequest(@JsonProperty(value="taskGroupIds") List<Integer> taskGroupIds) {
            this.taskGroupIds = taskGroupIds;
        }

        @JsonProperty
        public List<Integer> getTaskGroupIds() {
            return this.taskGroupIds;
        }
    }
}

