/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.server.security.ResourceAction;

@LazySingleton
public class SqlLifecycleManager {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<String, List<Cancelable>> sqlLifecycles = new HashMap<String, List<Cancelable>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String sqlQueryId, Cancelable lifecycle) {
        Object object = this.lock;
        synchronized (object) {
            this.sqlLifecycles.computeIfAbsent(sqlQueryId, k -> new ArrayList()).add(lifecycle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String sqlQueryId, Cancelable lifecycle) {
        Object object = this.lock;
        synchronized (object) {
            List<Cancelable> lifecycles = this.sqlLifecycles.get(sqlQueryId);
            if (lifecycles != null) {
                lifecycles.remove(lifecycle);
                if (lifecycles.isEmpty()) {
                    this.sqlLifecycles.remove(sqlQueryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String sqlQueryId, List<Cancelable> lifecyclesToRemove) {
        Object object = this.lock;
        synchronized (object) {
            List<Cancelable> lifecycles = this.sqlLifecycles.get(sqlQueryId);
            if (lifecycles != null) {
                lifecycles.removeAll(lifecyclesToRemove);
                if (lifecycles.isEmpty()) {
                    this.sqlLifecycles.remove(sqlQueryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cancelable> getAll(String sqlQueryId) {
        Object object = this.lock;
        synchronized (object) {
            List<Cancelable> lifecycles = this.sqlLifecycles.get(sqlQueryId);
            return lifecycles == null ? Collections.emptyList() : ImmutableList.copyOf(lifecycles);
        }
    }

    public static interface Cancelable {
        public Set<ResourceAction> resources();

        public void cancel();
    }
}

