/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.sql.SqlNode;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.sql.calcite.parser.DruidSqlParser;
import org.apache.druid.sql.calcite.parser.StatementAndSetContext;
import org.apache.druid.sql.http.SqlParameter;
import org.apache.druid.sql.http.SqlQuery;

public class SqlQueryPlus {
    private final String sql;
    @Nullable
    private final SqlNode sqlNode;
    private boolean allowSetStatements;
    private final Map<String, Object> queryContext;
    private final List<TypedValue> parameters;
    private final AuthenticationResult authResult;

    private SqlQueryPlus(String sql, SqlNode sqlNode, boolean allowSetStatements, Map<String, Object> queryContext, List<TypedValue> parameters, AuthenticationResult authResult) {
        this.sql = (String)Preconditions.checkNotNull((Object)sql);
        this.sqlNode = sqlNode;
        this.allowSetStatements = allowSetStatements;
        this.queryContext = queryContext == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(queryContext));
        this.parameters = parameters == null ? Collections.emptyList() : parameters;
        this.authResult = (AuthenticationResult)Preconditions.checkNotNull((Object)authResult);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String sql) {
        return new Builder().sql(sql);
    }

    public String sql() {
        return this.sql;
    }

    public SqlNode sqlNode() {
        if (this.sqlNode == null) {
            throw DruidException.defensive((String)"sqlNode not set", (Object[])new Object[0]);
        }
        return this.sqlNode;
    }

    public Map<String, Object> context() {
        return this.queryContext;
    }

    public List<TypedValue> parameters() {
        return this.parameters;
    }

    public AuthenticationResult authResult() {
        return this.authResult;
    }

    public SqlQueryPlus withContext(Map<String, Object> context) {
        return new SqlQueryPlus(this.sql, this.sqlNode, this.allowSetStatements, context, this.parameters, this.authResult);
    }

    public SqlQueryPlus withParameters(List<TypedValue> parameters) {
        return new SqlQueryPlus(this.sql, this.sqlNode, this.allowSetStatements, this.queryContext, parameters, this.authResult);
    }

    public SqlQueryPlus freshCopy() {
        return new SqlQueryPlus(this.sql, DruidSqlParser.parse(this.sql, this.allowSetStatements).getMainStatement(), this.allowSetStatements, this.queryContext, this.parameters, this.authResult);
    }

    public String toString() {
        return "SqlQueryPlus{sql='" + this.sql + "', sqlNode=" + String.valueOf(this.sqlNode) + ", queryContext=" + String.valueOf(this.queryContext) + ", parameters=" + String.valueOf(this.parameters) + ", authResult=" + String.valueOf(this.authResult) + "}";
    }

    public static class Builder {
        private String sql;
        private Map<String, Object> queryContext;
        private List<TypedValue> parameters;
        private AuthenticationResult authResult;

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder context(Map<String, Object> queryContext) {
            this.queryContext = queryContext;
            return this;
        }

        public Builder parameters(List<TypedValue> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder sqlParameters(List<SqlParameter> parameters) {
            this.parameters = parameters == null ? null : SqlQuery.getParameterList(parameters);
            return this;
        }

        public Builder auth(AuthenticationResult authResult) {
            this.authResult = authResult;
            return this;
        }

        public SqlQueryPlus build() {
            StatementAndSetContext statementAndSetContext = DruidSqlParser.parse(this.sql, true);
            return new SqlQueryPlus(this.sql, statementAndSetContext.getMainStatement(), true, statementAndSetContext.getSetContext().isEmpty() ? this.queryContext : QueryContexts.override(this.queryContext, statementAndSetContext.getSetContext()), this.parameters, this.authResult);
        }

        public SqlQueryPlus buildJdbc() {
            return new SqlQueryPlus(this.sql, null, false, this.queryContext, this.parameters, this.authResult);
        }
    }
}

