/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class SqlRowTransformer {
    private final DateTimeZone timeZone;
    private final RelDataType rowType;
    private final List<String> fieldList;
    private final boolean[] timeColumns;
    private final boolean[] dateColumns;

    SqlRowTransformer(DateTimeZone timeZone, RelDataType rowType) {
        this.timeZone = timeZone;
        this.rowType = rowType;
        this.fieldList = new ArrayList<String>(rowType.getFieldCount());
        this.timeColumns = new boolean[rowType.getFieldCount()];
        this.dateColumns = new boolean[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            SqlTypeName sqlTypeName = ((RelDataTypeField)rowType.getFieldList().get(i)).getType().getSqlTypeName();
            this.timeColumns[i] = sqlTypeName == SqlTypeName.TIMESTAMP;
            this.dateColumns[i] = sqlTypeName == SqlTypeName.DATE;
            this.fieldList.add(((RelDataTypeField)rowType.getFieldList().get(i)).getName());
        }
    }

    public RelDataType getRowType() {
        return this.rowType;
    }

    public List<String> getFieldList() {
        return this.fieldList;
    }

    @Nullable
    public Object transform(Object[] row, int i) {
        if (row[i] == null) {
            return null;
        }
        if (this.timeColumns[i]) {
            return ISODateTimeFormat.dateTime().print((ReadableInstant)Calcites.calciteTimestampToJoda((Long)row[i], this.timeZone));
        }
        if (this.dateColumns[i]) {
            return ISODateTimeFormat.dateTime().print((ReadableInstant)Calcites.calciteDateToJoda((Integer)row[i], this.timeZone));
        }
        return row[i];
    }
}

