/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class RPadOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("RPAD").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.CHARACTER).returnTypeCascadeNullable(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).requiredOperandCount(2).build();

    @Override
    public SqlOperator calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> {
            if (druidExpressions.size() > 2) {
                return DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), "rpad", (List<DruidExpression>)ImmutableList.of((Object)((DruidExpression)druidExpressions.get(0)), (Object)((DruidExpression)druidExpressions.get(1)), (Object)((DruidExpression)druidExpressions.get(2))));
            }
            return DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), "rpad", (List<DruidExpression>)ImmutableList.of((Object)((DruidExpression)druidExpressions.get(0)), (Object)((DruidExpression)druidExpressions.get(1)), (Object)DruidExpression.ofStringLiteral(" ")));
        });
    }
}

