/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidOuterQueryRel
extends DruidRel<DruidOuterQueryRel> {
    static final TableDataSource DUMMY_DATA_SOURCE = new TableDataSource("__subquery__"){

        public boolean isProcessable() {
            return false;
        }
    };
    private static final QueryDataSource DUMMY_QUERY_DATA_SOURCE = new QueryDataSource((Query)Druids.newScanQueryBuilder().dataSource("__subquery__").eternityInterval().build());
    private final PartialDruidQuery partialQuery;
    private RelNode sourceRel;

    private DruidOuterQueryRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode sourceRel, PartialDruidQuery partialQuery, PlannerContext plannerContext) {
        super(cluster, traitSet, plannerContext);
        this.sourceRel = sourceRel;
        this.partialQuery = partialQuery;
    }

    public static DruidOuterQueryRel create(DruidRel sourceRel, PartialDruidQuery partialQuery) {
        return new DruidOuterQueryRel(sourceRel.getCluster(), partialQuery.getTraitSet(sourceRel.getConvention(), sourceRel.getPlannerContext()), (RelNode)sourceRel, partialQuery, sourceRel.getPlannerContext());
    }

    @Override
    public PartialDruidQuery getPartialDruidQuery() {
        return this.partialQuery;
    }

    @Override
    public DruidOuterQueryRel withPartialQuery(PartialDruidQuery newQueryBuilder) {
        return new DruidOuterQueryRel(this.getCluster(), newQueryBuilder.getTraitSet(this.getConvention(), this.getPlannerContext()), this.sourceRel, newQueryBuilder, this.getPlannerContext());
    }

    @Override
    public DruidQuery toDruidQuery(boolean finalizeAggregations) {
        DruidQuery subQuery = ((DruidRel)this.sourceRel).toDruidQuery(true);
        RowSignature sourceRowSignature = subQuery.getOutputRowSignature();
        return this.partialQuery.build((DataSource)new QueryDataSource(subQuery.getQuery()), sourceRowSignature, this.getPlannerContext(), this.getCluster().getRexBuilder(), finalizeAggregations, true);
    }

    @Override
    public DruidQuery toDruidQueryForExplaining() {
        return this.partialQuery.build((DataSource)(this.partialQuery.getWindow() == null ? DUMMY_DATA_SOURCE : DUMMY_QUERY_DATA_SOURCE), RowSignatures.fromRelDataType(this.sourceRel.getRowType().getFieldNames(), this.sourceRel.getRowType()), this.getPlannerContext(), this.getCluster().getRexBuilder(), false, false);
    }

    @Override
    public DruidOuterQueryRel asDruidConvention() {
        return new DruidOuterQueryRel(this.getCluster(), this.getTraitSet().plus((RelTrait)DruidConvention.instance()), RelOptRule.convert((RelNode)this.sourceRel, (RelTrait)DruidConvention.instance()), this.partialQuery, this.getPlannerContext());
    }

    public List<RelNode> getInputs() {
        return ImmutableList.of((Object)this.sourceRel);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        if (ordinalInParent != 0) {
            throw new IndexOutOfBoundsException(StringUtils.format((String)"Invalid ordinalInParent[%s]", (Object[])new Object[]{ordinalInParent}));
        }
        this.sourceRel = p;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidOuterQueryRel(this.getCluster(), traitSet, (RelNode)Iterables.getOnlyElement(inputs), this.getPartialDruidQuery(), this.getPlannerContext());
    }

    @Override
    public Set<String> getDataSourceNames() {
        return ((DruidRel)this.sourceRel).getDataSourceNames();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String queryString;
        DruidQuery druidQuery = this.toDruidQueryForExplaining();
        try {
            queryString = this.getPlannerContext().getJsonMapper().writeValueAsString(druidQuery.getQuery());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return pw.input("innerQuery", this.sourceRel).item("query", (Object)queryString).item("signature", (Object)druidQuery.getOutputRowSignature());
    }

    protected RelDataType deriveRowType() {
        return this.partialQuery.getRowType();
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeCost(this.partialQuery.estimateCost(), 0.0, 0.0).multiplyBy(0.1).plus(planner.getCostFactory().makeCost(100000.0, 0.0, 0.0));
    }
}

