/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidRels;
import org.apache.druid.sql.calcite.rel.DruidUnionDataSourceRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DruidUnionDataSourceRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public DruidUnionDataSourceRule(PlannerContext plannerContext) {
        super(DruidUnionDataSourceRule.operand(Union.class, (RelOptRuleOperand)DruidUnionDataSourceRule.operand(DruidRel.class, (RelOptRuleOperandChildren)DruidUnionDataSourceRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[]{DruidUnionDataSourceRule.operand(DruidQueryRel.class, (RelOptRuleOperandChildren)DruidUnionDataSourceRule.none())}));
        this.plannerContext = plannerContext;
    }

    public boolean matches(RelOptRuleCall call) {
        Union unionRel = (Union)call.rel(0);
        DruidRel firstDruidRel = (DruidRel)call.rel(1);
        DruidQueryRel secondDruidRel = (DruidQueryRel)call.rel(2);
        return DruidUnionDataSourceRule.isCompatible(unionRel, firstDruidRel, secondDruidRel, this.plannerContext);
    }

    public void onMatch(RelOptRuleCall call) {
        Union unionRel = (Union)call.rel(0);
        DruidRel firstDruidRel = (DruidRel)call.rel(1);
        DruidQueryRel secondDruidRel = (DruidQueryRel)call.rel(2);
        if (firstDruidRel instanceof DruidUnionDataSourceRel) {
            RelNode newUnionRel = call.builder().pushAll((Iterable)firstDruidRel.getInputs()).push((RelNode)secondDruidRel).union(true, firstDruidRel.getInputs().size() + 1).build();
            call.transformTo((RelNode)DruidUnionDataSourceRel.create((Union)newUnionRel, DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(firstDruidRel, this.plannerContext).get(), firstDruidRel.getPlannerContext()));
        } else {
            if (!(firstDruidRel instanceof DruidQueryRel)) {
                throw new ISE("Expected first rel to be a DruidQueryRel, but it was %s", new Object[]{((Object)((Object)firstDruidRel)).getClass().getName()});
            }
            call.transformTo((RelNode)DruidUnionDataSourceRel.create(unionRel, DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(firstDruidRel, this.plannerContext).get(), firstDruidRel.getPlannerContext()));
        }
    }

    public static boolean isCompatible(Union unionRel, DruidRel<?> first, DruidRel<?> second, @Nullable PlannerContext plannerContext) {
        if (!(second instanceof DruidQueryRel)) {
            return false;
        }
        if (!unionRel.all && null != plannerContext) {
            plannerContext.setPlanningError("SQL requires 'UNION' but only 'UNION ALL' is supported.", new Object[0]);
        }
        return unionRel.all && DruidUnionDataSourceRule.isUnionCompatible(first, second, plannerContext);
    }

    private static boolean isUnionCompatible(DruidRel<?> first, DruidRel<?> second, @Nullable PlannerContext plannerContext) {
        Optional<List<String>> firstColumnNames = DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(first, plannerContext);
        Optional<List<String>> secondColumnNames = DruidUnionDataSourceRule.getColumnNamesIfTableOrUnion(second, plannerContext);
        if (!firstColumnNames.isPresent() || !secondColumnNames.isPresent()) {
            return false;
        }
        if (!firstColumnNames.equals(secondColumnNames)) {
            if (null != plannerContext) {
                plannerContext.setPlanningError("SQL requires union between two tables and column names queried for each table are different Left: %s, Right: %s.", firstColumnNames.orElse(Collections.emptyList()), secondColumnNames.orElse(Collections.emptyList()));
            }
            return false;
        }
        return true;
    }

    static Optional<List<String>> getColumnNamesIfTableOrUnion(DruidRel<?> druidRel, @Nullable PlannerContext plannerContext) {
        PartialDruidQuery partialQuery = druidRel.getPartialDruidQuery();
        Optional<DruidTable> druidTable = DruidRels.druidTableIfLeafRel(druidRel).filter(table -> table.getDataSource() instanceof TableDataSource);
        if (druidTable.isPresent() && DruidRels.isScanOrMapping(druidRel, false)) {
            if (partialQuery.stage() == PartialDruidQuery.Stage.SCAN) {
                return Optional.of(druidTable.get().getRowSignature().getColumnNames());
            }
            if (partialQuery.stage() != PartialDruidQuery.Stage.SELECT_PROJECT) {
                throw new ISE("Expected stage %s but got %s", new Object[]{PartialDruidQuery.Stage.SELECT_PROJECT, partialQuery.stage()});
            }
            RowSignature tableSignature = druidTable.get().getRowSignature();
            Mappings.TargetMapping mapping = partialQuery.getSelectProject().getMapping();
            if (mapping.getSourceCount() != tableSignature.size()) {
                throw new ISE("Expected mapping with %d columns but got %d columns", new Object[]{tableSignature.size(), mapping.getSourceCount()});
            }
            ArrayList<String> retVal = new ArrayList<String>();
            for (int i = 0; i < mapping.getTargetCount(); ++i) {
                int sourceField = mapping.getSourceOpt(i);
                retVal.add(tableSignature.getColumnName(sourceField));
            }
            return Optional.of(retVal);
        }
        if (!druidTable.isPresent() && druidRel instanceof DruidUnionDataSourceRel) {
            return Optional.of(((DruidUnionDataSourceRel)druidRel).getUnionColumnNames());
        }
        if (druidTable.isPresent()) {
            if (null != plannerContext) {
                plannerContext.setPlanningError("SQL requires union between inputs that are not simple table scans and involve a filter or aliasing. Or column types of tables being unioned are not of same type.", new Object[0]);
            }
            return Optional.empty();
        }
        if (null != plannerContext) {
            plannerContext.setPlanningError("SQL requires union with input of a datasource type that is not supported. Union operation is only supported between regular tables. ", new Object[0]);
        }
        return Optional.empty();
    }
}

