/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.logical.DruidAggregate;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;

public class DruidAggregateRule
extends ConverterRule {
    private final PlannerContext plannerContext;

    public DruidAggregateRule(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String descriptionPrefix, PlannerContext plannerContext) {
        super(clazz, in, out, descriptionPrefix);
        this.plannerContext = plannerContext;
    }

    public RelNode convert(RelNode rel) {
        LogicalAggregate aggregate = (LogicalAggregate)rel;
        RelTraitSet newTrait = this.deriveTraits((Aggregate)aggregate, aggregate.getTraitSet());
        return new DruidAggregate(aggregate.getCluster(), newTrait, DruidAggregateRule.convert((RelNode)aggregate.getInput(), (RelTraitSet)aggregate.getInput().getTraitSet().replace((RelTrait)DruidLogicalConvention.instance())), aggregate.getGroupSet(), (List<ImmutableBitSet>)aggregate.getGroupSets(), aggregate.getAggCallList(), this.plannerContext);
    }

    private RelTraitSet deriveTraits(Aggregate aggregate, RelTraitSet traits) {
        RelCollation collation = (RelCollation)traits.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
        if ((collation == null || collation.getFieldCollations().isEmpty()) && aggregate.getGroupSets().size() == 1) {
            ArrayList<RelFieldCollation> sortFields = new ArrayList<RelFieldCollation>();
            for (int i = 0; i < aggregate.getGroupCount(); ++i) {
                sortFields.add(new RelFieldCollation(i));
            }
            return traits.replace((RelTrait)DruidLogicalConvention.instance()).replace((RelTrait)RelCollations.of(sortFields));
        }
        return traits.replace((RelTrait)DruidLogicalConvention.instance());
    }
}

