/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.AvaticaUtils;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaSpnegoAuthenticator
extends SpnegoAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaSpnegoAuthenticator.class);

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        Authentication computedAuth = super.validateRequest(request, response, mandatory);
        try {
            return this.sendChallengeIfNecessary(computedAuth, request, response);
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    Authentication sendChallengeIfNecessary(Authentication computedAuth, ServletRequest request, ServletResponse response) throws IOException {
        if (computedAuth == Authentication.UNAUTHENTICATED) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String header = req.getHeader(HttpHeader.AUTHORIZATION.asString());
            if (header != null && !header.startsWith(HttpHeader.NEGOTIATE.asString())) {
                LOG.debug("Client sent Authorization header that was not for Negotiate, sending challenge anyways.");
                if (DeferredAuthentication.isDeferred((HttpServletResponse)res)) {
                    return Authentication.UNAUTHENTICATED;
                }
                res.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), HttpHeader.NEGOTIATE.asString());
                res.sendError(401);
                return Authentication.SEND_CONTINUE;
            }
        } else if (computedAuth == Authentication.SEND_CONTINUE) {
            HttpServletRequest req = (HttpServletRequest)request;
            AvaticaUtils.skipFully((InputStream)req.getInputStream());
        }
        return computedAuth;
    }
}

