/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingAvaticaHandler
implements AvaticaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingAvaticaHandler.class);
    private final Handler handler;

    public DelegatingAvaticaHandler(Handler handler) {
        this.handler = Objects.requireNonNull(handler);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.handler.handle(target, baseRequest, request, response);
    }

    public void setServer(Server server) {
        this.handler.setServer(server);
    }

    public Server getServer() {
        return this.handler.getServer();
    }

    public void destroy() {
        this.handler.destroy();
    }

    public void start() throws Exception {
        this.handler.start();
    }

    public void stop() throws Exception {
        this.handler.stop();
    }

    public boolean isRunning() {
        return this.handler.isRunning();
    }

    public boolean isStarted() {
        return this.handler.isStarted();
    }

    public boolean isStarting() {
        return this.handler.isStarting();
    }

    public boolean isStopping() {
        return this.handler.isStopping();
    }

    public boolean isStopped() {
        return this.handler.isStopped();
    }

    public boolean isFailed() {
        return this.handler.isFailed();
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.handler.addLifeCycleListener(listener);
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.handler.removeLifeCycleListener(listener);
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        LOG.warn("Setting RpcMetadata is not implemented for DelegatingAvaticaHandler");
    }
}

