/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.apache.datasketches.quantilescommon.SortedView;

public interface DoublesSortedView
extends SortedView {
    default public double[] getCDF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        QuantilesUtil.checkDoublesSplitPointsOrder(splitPoints);
        int len = splitPoints.length + 1;
        double[] buckets = new double[len];
        for (int i = 0; i < len - 1; ++i) {
            buckets[i] = this.getRank(splitPoints[i], searchCrit);
        }
        buckets[len - 1] = 1.0;
        return buckets;
    }

    default public double[] getPMF(double[] splitPoints, QuantileSearchCriteria searchCrit) {
        int len;
        double[] buckets = this.getCDF(splitPoints, searchCrit);
        int i = len = buckets.length;
        while (i-- > 1) {
            int n = i;
            buckets[n] = buckets[n] - buckets[i - 1];
        }
        return buckets;
    }

    public double getQuantile(double var1, QuantileSearchCriteria var3);

    public double[] getQuantiles();

    public double getRank(double var1, QuantileSearchCriteria var3);

    @Override
    public DoublesSortedViewIterator iterator();
}

