/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.SortedView;

public interface GenericSortedView<T>
extends SortedView {
    public double[] getCDF(T[] var1, QuantileSearchCriteria var2);

    public double[] getPMF(T[] var1, QuantileSearchCriteria var2);

    public T getQuantile(double var1, QuantileSearchCriteria var3);

    public T[] getQuantiles();

    public double getRank(T var1, QuantileSearchCriteria var2);

    @Override
    public GenericSortedViewIterator<T> iterator();

    public static <T> void validateItems(T[] items, Comparator<? super T> comparator) {
        int len = items.length;
        if (len == 1 && items[0] == null) {
            throw new SketchesArgumentException("Items must be unique, monotonically increasing and not null.");
        }
        for (int j = 0; j < len - 1; ++j) {
            if (items[j] != null && items[j + 1] != null && comparator.compare(items[j], items[j + 1]) < 0) continue;
            throw new SketchesArgumentException("Items must be unique, monotonically increasing and not null.");
        }
    }
}

