/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ResourceSizing {
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceSizing newInstance(Resource resources) {
        return ResourceSizing.newInstance(1, resources);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceSizing newInstance(int numAllocations, Resource resources) {
        ResourceSizing resourceSizing = Records.newRecord(ResourceSizing.class);
        resourceSizing.setNumAllocations(numAllocations);
        resourceSizing.setResources(resources);
        return resourceSizing;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getNumAllocations();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setNumAllocations(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Resource getResources();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setResources(Resource var1);

    public int hashCode() {
        int result = this.getResources().hashCode();
        result = 31 * result + this.getNumAllocations();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceSizing that = (ResourceSizing)obj;
        if (this.getNumAllocations() != that.getNumAllocations()) {
            return false;
        }
        return this.getResources().equals(that.getResources());
    }
}

