/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.protobuf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.os72.protobuf.dynamic.DynamicSchema;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.util.Objects;
import org.apache.druid.data.input.protobuf.DescriptorBasedProtobufBytesDecoder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;

public class InlineDescriptorProtobufBytesDecoder
extends DescriptorBasedProtobufBytesDecoder {
    private final String descriptorString;

    @JsonCreator
    public InlineDescriptorProtobufBytesDecoder(@JsonProperty(value="descriptorString") String descriptorString, @JsonProperty(value="protoMessageType") String protoMessageType) {
        super(protoMessageType);
        Preconditions.checkNotNull((Object)descriptorString);
        this.descriptorString = descriptorString;
        this.initDescriptor();
    }

    @JsonProperty
    public String getDescriptorString() {
        return this.descriptorString;
    }

    @Override
    protected DynamicSchema generateDynamicSchema() {
        try {
            byte[] decodedDesc = StringUtils.decodeBase64String((String)this.descriptorString);
            return DynamicSchema.parseFrom(decodedDesc);
        }
        catch (IllegalArgumentException e) {
            throw new IAE("Descriptor string does not have valid Base64 encoding.", new Object[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new ParseException(null, (Throwable)e, "Invalid descriptor string: " + this.descriptorString, new Object[0]);
        }
        catch (IOException e) {
            throw new ParseException(null, (Throwable)e, "Cannot read descriptor string: " + this.descriptorString, new Object[0]);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InlineDescriptorProtobufBytesDecoder that = (InlineDescriptorProtobufBytesDecoder)o;
        return Objects.equals(this.getDescriptorString(), that.getDescriptorString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDescriptorString());
    }
}

