/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka.supervisor;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.kafka.KafkaIndexTask;
import org.apache.druid.indexing.kafka.KafkaIndexTaskClientFactory;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisor;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorIOConfig;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorIngestionSpec;
import org.apache.druid.indexing.kafka.supervisor.KafkaSupervisorTuningConfig;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskMaster;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManagerConfig;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskClientFactory;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorIngestionSpec;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisorSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.DruidMonitorSchedulerConfig;
import org.apache.druid.segment.incremental.RowIngestionMetersFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.server.security.ResourceAction;

public class KafkaSupervisorSpec
extends SeekableStreamSupervisorSpec {
    static final String TASK_TYPE = "kafka";

    @JsonCreator
    public KafkaSupervisorSpec(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="spec") @Nullable KafkaSupervisorIngestionSpec ingestionSchema, @JsonProperty(value="dataSchema") @Nullable DataSchema dataSchema, @JsonProperty(value="tuningConfig") @Nullable KafkaSupervisorTuningConfig tuningConfig, @JsonProperty(value="ioConfig") @Nullable KafkaSupervisorIOConfig ioConfig, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="suspended") Boolean suspended, @JacksonInject TaskStorage taskStorage, @JacksonInject TaskMaster taskMaster, @JacksonInject IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, @JacksonInject KafkaIndexTaskClientFactory kafkaIndexTaskClientFactory, @JacksonInject @Json ObjectMapper mapper, @JacksonInject ServiceEmitter emitter, @JacksonInject DruidMonitorSchedulerConfig monitorSchedulerConfig, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject SupervisorStateManagerConfig supervisorStateManagerConfig) {
        super(id, (SeekableStreamSupervisorIngestionSpec)(ingestionSchema != null ? ingestionSchema : new KafkaSupervisorIngestionSpec(dataSchema, ioConfig, tuningConfig != null ? tuningConfig : KafkaSupervisorTuningConfig.defaultConfig())), context, suspended, taskStorage, taskMaster, indexerMetadataStorageCoordinator, (SeekableStreamIndexTaskClientFactory)kafkaIndexTaskClientFactory, mapper, emitter, monitorSchedulerConfig, rowIngestionMetersFactory, supervisorStateManagerConfig);
    }

    public String getType() {
        return TASK_TYPE;
    }

    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return KafkaIndexTask.INPUT_SOURCE_RESOURCES;
    }

    public String getSource() {
        return this.getIoConfig() != null ? this.getIoConfig().getStream() : null;
    }

    public Supervisor createSupervisor() {
        return new KafkaSupervisor(this.taskStorage, this.taskMaster, this.indexerMetadataStorageCoordinator, (KafkaIndexTaskClientFactory)this.indexTaskClientFactory, this.mapper, this, this.rowIngestionMetersFactory);
    }

    @Deprecated
    @JsonProperty
    public KafkaSupervisorTuningConfig getTuningConfig() {
        return (KafkaSupervisorTuningConfig)super.getTuningConfig();
    }

    @Deprecated
    @JsonProperty
    public KafkaSupervisorIOConfig getIoConfig() {
        return (KafkaSupervisorIOConfig)super.getIoConfig();
    }

    @JsonProperty
    public KafkaSupervisorIngestionSpec getSpec() {
        return (KafkaSupervisorIngestionSpec)super.getSpec();
    }

    protected KafkaSupervisorSpec toggleSuspend(boolean suspend) {
        return new KafkaSupervisorSpec(this.getId(), this.getSpec(), this.getDataSchema(), this.getTuningConfig(), this.getIoConfig(), this.getContext(), suspend, this.taskStorage, this.taskMaster, this.indexerMetadataStorageCoordinator, (KafkaIndexTaskClientFactory)this.indexTaskClientFactory, this.mapper, this.emitter, this.monitorSchedulerConfig, this.rowIngestionMetersFactory, this.supervisorStateManagerConfig);
    }

    public void validateSpecUpdateTo(SupervisorSpec proposedSpec) throws DruidException {
        if (!(proposedSpec instanceof KafkaSupervisorSpec)) {
            throw InvalidInput.exception((String)"Cannot change spec from type[%s] to type[%s]", (Object[])new Object[]{((Object)((Object)this)).getClass().getSimpleName(), proposedSpec.getClass().getSimpleName()});
        }
        KafkaSupervisorSpec other = (KafkaSupervisorSpec)proposedSpec;
        if (this.getSpec().getIOConfig().isMultiTopic() != other.getSpec().getIOConfig().isMultiTopic()) {
            throw InvalidInput.exception((String)"Update of the input source stream from [%s] to [%s] is not supported for a running supervisor.%nTo perform the update safely, follow these steps:%n(1) Suspend this supervisor, reset its offsets and then terminate it. %n(2) Create a new supervisor with the new input source stream.%nNote that doing the reset can cause data duplication or loss if any topic used in the old supervisor is included in the new one too.", (Object[])new Object[]{StringUtils.format((String)"(%s) %s", (Object[])new Object[]{this.getSpec().getIOConfig().isMultiTopic() ? "multi-topic" : "single-topic", this.getSource()}), StringUtils.format((String)"(%s) %s", (Object[])new Object[]{other.getSpec().getIOConfig().isMultiTopic() ? "multi-topic" : "single-topic", other.getSource()})});
        }
        super.validateSpecUpdateTo(proposedSpec);
    }

    public String toString() {
        return "KafkaSupervisorSpec{dataSchema=" + String.valueOf(this.getDataSchema()) + ", tuningConfig=" + String.valueOf((Object)this.getTuningConfig()) + ", ioConfig=" + String.valueOf((Object)this.getIoConfig()) + ", context=" + String.valueOf(this.getContext()) + ", suspend=" + this.isSuspended() + "}";
    }
}

