/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchOperations;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.SafeWritableMemory;

public class DoublesSketchObjectStrategy
implements ObjectStrategy<DoublesSketch> {
    public int compare(DoublesSketch s1, DoublesSketch s2) {
        return DoublesSketchAggregatorFactory.COMPARATOR.compare(s1, s2);
    }

    public DoublesSketch fromByteBuffer(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return DoublesSketchOperations.EMPTY_SKETCH;
        }
        return DoublesSketch.wrap((Memory)Memory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }

    public Class<DoublesSketch> getClazz() {
        return DoublesSketch.class;
    }

    public byte[] toBytes(DoublesSketch sketch) {
        if (sketch == null || sketch.isEmpty()) {
            return ByteArrays.EMPTY_ARRAY;
        }
        return sketch.toByteArray(true);
    }

    @Nullable
    public DoublesSketch fromByteBufferSafe(ByteBuffer buffer, int numBytes) {
        if (numBytes == 0) {
            return DoublesSketchOperations.EMPTY_SKETCH;
        }
        return DoublesSketch.wrap((Memory)SafeWritableMemory.wrap((ByteBuffer)buffer, (ByteOrder)ByteOrder.LITTLE_ENDIAN).region((long)buffer.position(), (long)numBytes));
    }
}

