/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteShareGroupStateResponse;

public class DeleteShareGroupStateRequest
extends AbstractRequest {
    private final DeleteShareGroupStateRequestData data;

    public DeleteShareGroupStateRequest(DeleteShareGroupStateRequestData data, short version) {
        super(ApiKeys.DELETE_SHARE_GROUP_STATE, version);
        this.data = data;
    }

    @Override
    public DeleteShareGroupStateResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<DeleteShareGroupStateResponseData.DeleteStateResult> results = new ArrayList<DeleteShareGroupStateResponseData.DeleteStateResult>();
        this.data.topics().forEach(topicResult -> results.add(new DeleteShareGroupStateResponseData.DeleteStateResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code())).collect(Collectors.toList()))));
        return new DeleteShareGroupStateResponse(new DeleteShareGroupStateResponseData().setResults(results));
    }

    @Override
    public DeleteShareGroupStateRequestData data() {
        return this.data;
    }

    public static DeleteShareGroupStateRequest parse(ByteBuffer buffer, short version) {
        return new DeleteShareGroupStateRequest(new DeleteShareGroupStateRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteShareGroupStateRequest> {
        private final DeleteShareGroupStateRequestData data;

        public Builder(DeleteShareGroupStateRequestData data) {
            this(data, false);
        }

        public Builder(DeleteShareGroupStateRequestData data, boolean enableUnstableLastVersion) {
            super(ApiKeys.DELETE_SHARE_GROUP_STATE, enableUnstableLastVersion);
            this.data = data;
        }

        @Override
        public DeleteShareGroupStateRequest build(short version) {
            return new DeleteShareGroupStateRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

