/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;

public class LocalOutputFile
implements OutputFile {
    private static final int BUFFER_SIZE_DEFAULT = 4096;
    private final Path path;

    public LocalOutputFile(Path file) {
        this.path = file;
    }

    @Override
    public PositionOutputStream create(long blockSize) throws IOException {
        return new LocalPositionOutputStream(4096, StandardOpenOption.CREATE_NEW);
    }

    @Override
    public PositionOutputStream createOrOverwrite(long blockSize) throws IOException {
        return new LocalPositionOutputStream(4096, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public boolean supportsBlockSize() {
        return false;
    }

    @Override
    public long defaultBlockSize() {
        return -1L;
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    private class LocalPositionOutputStream
    extends PositionOutputStream {
        private final BufferedOutputStream stream;
        private long pos = 0L;

        public LocalPositionOutputStream(int buffer, StandardOpenOption ... openOption) throws IOException {
            this.stream = new BufferedOutputStream(Files.newOutputStream(LocalOutputFile.this.path, openOption), buffer);
        }

        @Override
        public long getPos() {
            return this.pos;
        }

        @Override
        public void write(int data) throws IOException {
            ++this.pos;
            this.stream.write(data);
        }

        @Override
        public void write(byte[] data) throws IOException {
            this.pos += (long)data.length;
            this.stream.write(data);
        }

        @Override
        public void write(byte[] data, int off, int len) throws IOException {
            this.pos += (long)len;
            this.stream.write(data, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            try (BufferedOutputStream os = this.stream;){
                ((OutputStream)os).flush();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

