/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.indexer.DataSegmentAndIndexZipFilePath;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.IndexGeneratorJob;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.indexer.path.SegmentMetadataPublisher;
import org.apache.druid.timeline.DataSegment;

public class MetadataStorageUpdaterJob
implements Jobby {
    private final HadoopDruidIndexerConfig config;
    private final SegmentMetadataPublisher handler;

    public MetadataStorageUpdaterJob(HadoopDruidIndexerConfig config, SegmentMetadataPublisher handler) {
        this.config = config;
        this.handler = handler;
    }

    public boolean run() {
        List<DataSegmentAndIndexZipFilePath> segmentAndIndexZipFilePaths = IndexGeneratorJob.getPublishedSegmentAndIndexZipFilePaths(this.config);
        Set<DataSegment> segments = segmentAndIndexZipFilePaths.stream().map(DataSegmentAndIndexZipFilePath::getSegment).collect(Collectors.toSet());
        this.handler.publishSegments(segments);
        return true;
    }
}

