/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.HashSet;
import java.util.Set;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.sqlobject.HandleDing;

class OnDemandHandleDing
implements HandleDing {
    private final IDBI dbi;
    private final ThreadLocal<LocalDing> threadDing = new ThreadLocal();

    OnDemandHandleDing(IDBI dbi) {
        this.dbi = dbi;
    }

    @Override
    public Handle getHandle() {
        if (this.threadDing.get() == null) {
            this.threadDing.set(new LocalDing(this.dbi.open()));
        }
        return this.threadDing.get().getHandle();
    }

    @Override
    public void retain(String name) {
        this.getHandle();
        this.threadDing.get().retain(name);
    }

    @Override
    public void release(String name) {
        LocalDing ding = this.threadDing.get();
        if (ding == null) {
            return;
        }
        ding.release(name);
    }

    class LocalDing
    implements HandleDing {
        private final Set<String> retentions = new HashSet<String>();
        private final Handle handle;

        public LocalDing(Handle handle) {
            this.handle = handle;
        }

        @Override
        public Handle getHandle() {
            return this.handle;
        }

        @Override
        public void release(String name) {
            this.retentions.remove(name);
            if (this.retentions.isEmpty()) {
                OnDemandHandleDing.this.threadDing.set(null);
                this.handle.close();
            }
        }

        @Override
        public void retain(String name) {
            this.retentions.add(name);
        }
    }
}

