/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.policy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.segment.CursorBuildSpec;

public class RowFilterPolicy
implements Policy {
    private final DimFilter rowFilter;

    @JsonCreator
    RowFilterPolicy(@Nonnull @JsonProperty(value="rowFilter") DimFilter rowFilter) {
        this.rowFilter = (DimFilter)Preconditions.checkNotNull((Object)rowFilter, (Object)"rowFilter can't be null");
    }

    public static RowFilterPolicy from(@Nonnull DimFilter rowFilter) {
        return new RowFilterPolicy(rowFilter);
    }

    @JsonProperty
    public DimFilter getRowFilter() {
        return this.rowFilter;
    }

    @Override
    public CursorBuildSpec visit(CursorBuildSpec spec) {
        return CursorBuildSpec.builder(spec).andFilter(this.rowFilter.toFilter()).build();
    }

    public String toString() {
        return "RowFilterPolicy{rowFilter=" + this.rowFilter + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowFilterPolicy that = (RowFilterPolicy)o;
        return Objects.equals(this.rowFilter, that.rowFilter);
    }

    public int hashCode() {
        return Objects.hash(this.rowFilter);
    }
}

