/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols.concrete;

import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.concrete.AbstractFrameRowsAndColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class RowBasedFrameRowsAndColumns
extends AbstractFrameRowsAndColumns {
    public RowBasedFrameRowsAndColumns(Frame frame, RowSignature signature) {
        super(frame.ensureRowBased(), signature);
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (!this.colCache.containsKey(name)) {
            int columnIndex = this.signature.indexOf(name);
            if (columnIndex < 0) {
                this.colCache.put(name, null);
            } else {
                ColumnType columnType = this.signature.getColumnType(columnIndex).orElseThrow(() -> DruidException.defensive("just got the id [%s][%s], why is columnType not there?", columnIndex, name));
                FieldReader reader = FieldReaders.create(name, columnType, this.frame.type());
                this.colCache.put(name, reader.makeRACColumn(this.frame, this.signature, name));
            }
        }
        return (Column)this.colCache.get(name);
    }
}

