/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.utils.CollectionUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonTypeName(value="aggregate")
public class AggregateProjectionMetadata {
    private static final Interner<Schema> SCHEMA_INTERNER = Interners.newWeakInterner();
    public static final Comparator<AggregateProjectionMetadata> COMPARATOR = (o1, o2) -> {
        int rowCompare = Integer.compare(o1.numRows, o2.numRows);
        if (rowCompare != 0) {
            return rowCompare;
        }
        return Schema.COMPARATOR.compare(o1.getSchema(), o2.getSchema());
    };
    private final Schema schema;
    private final int numRows;

    public static SchemaBuilder schemaBuilder(String name) {
        return new SchemaBuilder().name(name);
    }

    @JsonCreator
    public AggregateProjectionMetadata(@JsonProperty(value="schema") Schema schema, @JsonProperty(value="numRows") int numRows) {
        this.schema = (Schema)SCHEMA_INTERNER.intern((Object)schema);
        this.numRows = numRows;
    }

    @JsonProperty
    public Schema getSchema() {
        return this.schema;
    }

    @JsonProperty
    public int getNumRows() {
        return this.numRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateProjectionMetadata that = (AggregateProjectionMetadata)o;
        return this.numRows == that.numRows && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.numRows);
    }

    public String toString() {
        return "AggregateProjectionMetadata{schema=" + this.schema + ", numRows=" + this.numRows + "}";
    }

    public static class SchemaBuilder {
        @Nullable
        private String name;
        @Nullable
        private String timeColumnName;
        private VirtualColumns virtualColumns = VirtualColumns.EMPTY;
        @Nullable
        private DimFilter filter;
        private List<String> groupingColumns;
        private AggregatorFactory[] aggregators;
        private List<OrderBy> ordering;

        public SchemaBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public SchemaBuilder timeColumnName(@Nullable String timeColumnName) {
            this.timeColumnName = timeColumnName;
            return this;
        }

        public SchemaBuilder virtualColumns(VirtualColumns virtualColumns) {
            this.virtualColumns = virtualColumns;
            return this;
        }

        public SchemaBuilder virtualColumns(VirtualColumn ... virtualColumns) {
            this.virtualColumns = VirtualColumns.create(virtualColumns);
            return this;
        }

        public SchemaBuilder filter(@Nullable DimFilter filter) {
            this.filter = filter;
            return this;
        }

        public SchemaBuilder groupAndOrder(String ... groupingColumns) {
            this.groupingColumns = Arrays.asList(groupingColumns);
            return this.ordering(groupingColumns);
        }

        public SchemaBuilder aggregators(AggregatorFactory ... aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        public SchemaBuilder ordering(String ... columnNames) {
            this.ordering = Arrays.stream(columnNames).map(OrderBy::ascending).collect(Collectors.toList());
            return this;
        }

        public SchemaBuilder ordering(List<OrderBy> ordering) {
            this.ordering = ordering;
            return this;
        }

        public Schema build() {
            return new Schema(this.name, this.timeColumnName, this.filter, this.virtualColumns, this.groupingColumns, this.aggregators, this.ordering);
        }
    }

    public static class Schema {
        public static final Comparator<Schema> COMPARATOR = (o1, o2) -> {
            if (o1.getEffectiveGranularity().isFinerThan(o2.getEffectiveGranularity())) {
                return 1;
            }
            if (o2.getEffectiveGranularity().isFinerThan(o1.getEffectiveGranularity())) {
                return -1;
            }
            int dimsCompare = Integer.compare(o1.groupingColumns.size(), o2.groupingColumns.size());
            if (dimsCompare != 0) {
                return dimsCompare;
            }
            int metCompare = Integer.compare(o2.aggregators.length, o1.aggregators.length);
            if (metCompare != 0) {
                return metCompare;
            }
            int virtCompare = Integer.compare(o2.virtualColumns.getVirtualColumns().length, o1.virtualColumns.getVirtualColumns().length);
            if (virtCompare != 0) {
                return virtCompare;
            }
            return o1.name.compareTo(o2.name);
        };
        private final String name;
        @Nullable
        private final String timeColumnName;
        @Nullable
        private final DimFilter filter;
        private final VirtualColumns virtualColumns;
        private final List<String> groupingColumns;
        private final AggregatorFactory[] aggregators;
        private final List<OrderBy> ordering;
        private final List<OrderBy> orderingWithTimeSubstitution;
        private final int timeColumnPosition;
        private final Granularity effectiveGranularity;

        @JsonCreator
        public Schema(@JsonProperty(value="name") String name, @JsonProperty(value="timeColumnName") @Nullable String timeColumnName, @JsonProperty(value="filter") @Nullable DimFilter filter, @JsonProperty(value="virtualColumns") @Nullable VirtualColumns virtualColumns, @JsonProperty(value="groupingColumns") @Nullable List<String> groupingColumns, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="ordering") List<OrderBy> ordering) {
            if (name == null || name.isEmpty()) {
                throw DruidException.defensive("projection schema name cannot be null or empty", new Object[0]);
            }
            this.name = name;
            if (CollectionUtils.isNullOrEmpty(groupingColumns) && (aggregators == null || aggregators.length == 0)) {
                throw DruidException.defensive("projection schema[%s] groupingColumns and aggregators must not both be null or empty", name);
            }
            if (ordering == null) {
                throw DruidException.defensive("projection schema[%s] ordering must not be null", name);
            }
            this.filter = filter;
            this.virtualColumns = virtualColumns == null ? VirtualColumns.EMPTY : virtualColumns;
            this.groupingColumns = groupingColumns == null ? Collections.emptyList() : groupingColumns;
            this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
            this.ordering = ordering;
            int foundTimePosition = -1;
            this.orderingWithTimeSubstitution = Lists.newArrayListWithCapacity((int)ordering.size());
            Granularity granularity = null;
            for (int i = 0; i < ordering.size(); ++i) {
                OrderBy orderBy = ordering.get(i);
                if (orderBy.getColumnName().equals(timeColumnName)) {
                    this.orderingWithTimeSubstitution.add(new OrderBy("__time", orderBy.getOrder()));
                    foundTimePosition = i;
                    timeColumnName = groupingColumns.get(foundTimePosition);
                    VirtualColumn vc = this.virtualColumns.getVirtualColumn(groupingColumns.get(foundTimePosition));
                    if (vc != null) {
                        granularity = Granularities.fromVirtualColumn(vc);
                        continue;
                    }
                    granularity = Granularities.NONE;
                    continue;
                }
                this.orderingWithTimeSubstitution.add(orderBy);
            }
            this.timeColumnName = timeColumnName;
            this.timeColumnPosition = foundTimePosition;
            this.effectiveGranularity = granularity == null ? Granularities.ALL : granularity;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        @Nullable
        public String getTimeColumnName() {
            return this.timeColumnName;
        }

        @JsonProperty
        @Nullable
        public DimFilter getFilter() {
            return this.filter;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public VirtualColumns getVirtualColumns() {
            return this.virtualColumns;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public List<String> getGroupingColumns() {
            return this.groupingColumns;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public AggregatorFactory[] getAggregators() {
            return this.aggregators;
        }

        @JsonProperty
        public List<OrderBy> getOrdering() {
            return this.ordering;
        }

        @JsonIgnore
        public List<OrderBy> getOrderingWithTimeColumnSubstitution() {
            return this.orderingWithTimeSubstitution;
        }

        @JsonIgnore
        public int getTimeColumnPosition() {
            return this.timeColumnPosition;
        }

        @JsonIgnore
        public Granularity getEffectiveGranularity() {
            return this.effectiveGranularity;
        }

        public boolean isInvalidGrouping(@Nullable String columnName) {
            if (columnName == null) {
                return false;
            }
            return !this.groupingColumns.contains(columnName) && this.virtualColumns.exists(columnName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Schema schema = (Schema)o;
            return Objects.equals(this.name, schema.name) && Objects.equals(this.timeColumnName, schema.timeColumnName) && Objects.equals(this.filter, schema.filter) && Objects.equals(this.virtualColumns, schema.virtualColumns) && Objects.equals(this.groupingColumns, schema.groupingColumns) && Objects.deepEquals(this.aggregators, schema.aggregators) && Objects.equals(this.ordering, schema.ordering);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.timeColumnName, this.filter, this.virtualColumns, this.groupingColumns, Arrays.hashCode(this.aggregators), this.ordering);
        }

        public String toString() {
            return "Schema{name='" + this.name + "', timeColumnName='" + this.timeColumnName + "', virtualColumns=" + this.virtualColumns + ", groupingColumns=" + this.groupingColumns + ", aggregators=" + Arrays.toString(this.aggregators) + ", ordering=" + this.ordering + ", timeColumnPosition=" + this.timeColumnPosition + ", effectiveGranularity=" + this.effectiveGranularity + ", orderingWithTimeSubstitution=" + this.orderingWithTimeSubstitution + "}";
        }
    }
}

