/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseBuffer;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.segment.data.SafeWritableBase;
import org.apache.druid.segment.data.SafeWritableMemory;

public class SafeWritableBuffer
extends SafeWritableBase
implements WritableBuffer {
    private int start = 0;
    private int end;

    public SafeWritableBuffer(ByteBuffer buffer) {
        super(buffer);
        this.buffer.position(0);
        this.end = buffer.capacity();
    }

    public WritableBuffer writableDuplicate() {
        return this.writableDuplicate(this.buffer.order());
    }

    public WritableBuffer writableDuplicate(ByteOrder byteOrder) {
        ByteBuffer dupe = this.buffer.duplicate();
        dupe.order(byteOrder);
        SafeWritableBuffer duplicate = new SafeWritableBuffer(dupe);
        duplicate.setStartPositionEnd(this.start, this.buffer.position(), this.end);
        return duplicate;
    }

    public WritableBuffer writableRegion() {
        ByteBuffer dupe = this.buffer.duplicate().order(this.buffer.order());
        dupe.position(this.start);
        dupe.limit(this.end);
        ByteBuffer remaining = this.buffer.slice();
        remaining.order(dupe.order());
        return new SafeWritableBuffer(remaining);
    }

    public WritableBuffer writableRegion(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        ByteBuffer dupe = this.buffer.duplicate();
        dupe.position(Ints.checkedCast((long)offsetBytes));
        dupe.limit(dupe.position() + Ints.checkedCast((long)capacityBytes));
        return new SafeWritableBuffer(dupe.slice().order(byteOrder));
    }

    public WritableMemory asWritableMemory(ByteOrder byteOrder) {
        ByteBuffer dupe = this.buffer.duplicate();
        dupe.order(byteOrder);
        return new SafeWritableMemory(dupe);
    }

    public void putBoolean(boolean value) {
        this.buffer.put((byte)(value ? 1 : 0));
    }

    public void putBooleanArray(boolean[] srcArray, int srcOffsetBooleans, int lengthBooleans) {
        for (int i = 0; i < lengthBooleans; ++i) {
            this.putBoolean(srcArray[srcOffsetBooleans + i]);
        }
    }

    public void putByte(byte value) {
        this.buffer.put(value);
    }

    public void putByteArray(byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        this.buffer.put(srcArray, srcOffsetBytes, lengthBytes);
    }

    public void putChar(char value) {
        this.buffer.putChar(value);
    }

    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        for (int i = 0; i < lengthChars; ++i) {
            this.buffer.putChar(srcArray[srcOffsetChars + i]);
        }
    }

    public void putDouble(double value) {
        this.buffer.putDouble(value);
    }

    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        for (int i = 0; i < lengthDoubles; ++i) {
            this.buffer.putDouble(srcArray[srcOffsetDoubles + i]);
        }
    }

    public void putFloat(float value) {
        this.buffer.putFloat(value);
    }

    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        for (int i = 0; i < lengthFloats; ++i) {
            this.buffer.putFloat(srcArray[srcOffsetFloats + i]);
        }
    }

    public void putInt(int value) {
        this.buffer.putInt(value);
    }

    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        for (int i = 0; i < lengthInts; ++i) {
            this.buffer.putInt(srcArray[srcOffsetInts + i]);
        }
    }

    public void putLong(long value) {
        this.buffer.putLong(value);
    }

    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        for (int i = 0; i < lengthLongs; ++i) {
            this.buffer.putLong(srcArray[srcOffsetLongs + i]);
        }
    }

    public void putShort(short value) {
        this.buffer.putShort(value);
    }

    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        for (int i = 0; i < lengthShorts; ++i) {
            this.buffer.putShort(srcArray[srcOffsetShorts + i]);
        }
    }

    public Object getArray() {
        return null;
    }

    public void clear() {
        this.fill((byte)0);
    }

    public void fill(byte value) {
        while (this.buffer.hasRemaining() && this.buffer.position() < this.end) {
            this.buffer.put(value);
        }
    }

    public Buffer duplicate() {
        return this.writableDuplicate();
    }

    public Buffer duplicate(ByteOrder byteOrder) {
        return this.writableDuplicate(byteOrder);
    }

    public Buffer region() {
        return this.writableRegion();
    }

    public Buffer region(long offsetBytes, long capacityBytes, ByteOrder byteOrder) {
        return this.writableRegion(offsetBytes, capacityBytes, byteOrder);
    }

    public Memory asMemory(ByteOrder byteOrder) {
        return this.asWritableMemory(byteOrder);
    }

    public boolean getBoolean() {
        return this.buffer.get() != 0;
    }

    public void getBooleanArray(boolean[] dstArray, int dstOffsetBooleans, int lengthBooleans) {
        for (int i = 0; i < lengthBooleans; ++i) {
            dstArray[dstOffsetBooleans + i] = this.getBoolean();
        }
    }

    public byte getByte() {
        return this.buffer.get();
    }

    public void getByteArray(byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        for (int i = 0; i < lengthBytes; ++i) {
            dstArray[dstOffsetBytes + i] = this.buffer.get();
        }
    }

    public char getChar() {
        return this.buffer.getChar();
    }

    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        for (int i = 0; i < lengthChars; ++i) {
            dstArray[dstOffsetChars + i] = this.buffer.getChar();
        }
    }

    public double getDouble() {
        return this.buffer.getDouble();
    }

    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        for (int i = 0; i < lengthDoubles; ++i) {
            dstArray[dstOffsetDoubles + i] = this.buffer.getDouble();
        }
    }

    public float getFloat() {
        return this.buffer.getFloat();
    }

    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        for (int i = 0; i < lengthFloats; ++i) {
            dstArray[dstOffsetFloats + i] = this.buffer.getFloat();
        }
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        for (int i = 0; i < lengthInts; ++i) {
            dstArray[dstOffsetInts + i] = this.buffer.getInt();
        }
    }

    public long getLong() {
        return this.buffer.getLong();
    }

    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        for (int i = 0; i < lengthLongs; ++i) {
            dstArray[dstOffsetLongs + i] = this.buffer.getLong();
        }
    }

    public short getShort() {
        return this.buffer.getShort();
    }

    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        for (int i = 0; i < lengthShorts; ++i) {
            dstArray[dstOffsetShorts + i] = this.buffer.getShort();
        }
    }

    public int compareTo(long thisOffsetBytes, long thisLengthBytes, Buffer that, long thatOffsetBytes, long thatLengthBytes) {
        int thisLength = Ints.checkedCast((long)thisLengthBytes);
        int thatLength = Ints.checkedCast((long)thatLengthBytes);
        int commonLength = Math.min(thisLength, thatLength);
        for (int i = 0; i < commonLength; ++i) {
            int cmp = Byte.compare(this.getByte(thisOffsetBytes + (long)i), that.getByte(thatOffsetBytes + (long)i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(thisLength, thatLength);
    }

    public BaseBuffer incrementPosition(long increment) {
        this.buffer.position(this.buffer.position() + Ints.checkedCast((long)increment));
        return this;
    }

    public BaseBuffer incrementAndCheckPosition(long increment) {
        SafeWritableBuffer.checkInvariants(this.start, (long)this.buffer.position() + increment, this.end, this.buffer.capacity());
        return this.incrementPosition(increment);
    }

    public long getEnd() {
        return this.end;
    }

    public long getPosition() {
        return this.buffer.position();
    }

    public long getStart() {
        return this.start;
    }

    public long getRemaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public BaseBuffer resetPosition() {
        this.buffer.position(this.start);
        return this;
    }

    public BaseBuffer setPosition(long position) {
        this.buffer.position(Ints.checkedCast((long)position));
        return this;
    }

    public BaseBuffer setAndCheckPosition(long position) {
        SafeWritableBuffer.checkInvariants(this.start, position, this.end, this.buffer.capacity());
        return this.setPosition(position);
    }

    public BaseBuffer setStartPositionEnd(long start, long position, long end) {
        this.start = Ints.checkedCast((long)start);
        this.end = Ints.checkedCast((long)end);
        this.buffer.position(Ints.checkedCast((long)position));
        this.buffer.limit(this.end);
        return this;
    }

    public BaseBuffer setAndCheckStartPositionEnd(long start, long position, long end) {
        SafeWritableBuffer.checkInvariants(start, position, end, this.buffer.capacity());
        return this.setStartPositionEnd(start, position, end);
    }

    public boolean equalTo(long thisOffsetBytes, Object that, long thatOffsetBytes, long lengthBytes) {
        if (!(that instanceof SafeWritableBuffer)) {
            return false;
        }
        return this.compareTo(thisOffsetBytes, lengthBytes, (Buffer)((SafeWritableBuffer)that), thatOffsetBytes, lengthBytes) == 0;
    }

    static void checkInvariants(long start, long pos, long end, long cap) {
        if ((start | pos | end | cap | pos - start | end - pos | cap - end) < 0L) {
            throw new IllegalArgumentException("Violation of Invariants: start: " + start + " <= pos: " + pos + " <= end: " + end + " <= cap: " + cap + "; (pos - start): " + (pos - start) + ", (end - pos): " + (end - pos) + ", (cap - end): " + (cap - end));
        }
    }
}

