/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.druid.curator.CuratorUtils;
import org.apache.druid.curator.announcement.ServiceAnnouncer;
import org.apache.druid.guice.annotations.DirectExecutorAnnouncer;
import org.apache.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.initialization.IndexerZkConfig;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class WorkerCuratorCoordinator {
    private static final Logger log = new Logger(WorkerCuratorCoordinator.class);
    private static final Joiner JOINER = Joiner.on((String)"/");
    private final Object lock = new Object();
    private final ObjectMapper jsonMapper;
    private final RemoteTaskRunnerConfig config;
    private final CuratorFramework curatorFramework;
    private final ServiceAnnouncer announcer;
    private final String baseAnnouncementsPath;
    private final String baseTaskPath;
    private final String baseStatusPath;
    private volatile Worker worker;
    private volatile boolean started;

    @Inject
    public WorkerCuratorCoordinator(ObjectMapper jsonMapper, IndexerZkConfig indexerZkConfig, RemoteTaskRunnerConfig config, CuratorFramework curatorFramework, @DirectExecutorAnnouncer ServiceAnnouncer announcer, Worker worker) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.curatorFramework = curatorFramework;
        this.worker = worker;
        this.announcer = announcer;
        this.baseAnnouncementsPath = this.getPath(Arrays.asList(indexerZkConfig.getAnnouncementsPath(), worker.getHost()));
        this.baseTaskPath = this.getPath(Arrays.asList(indexerZkConfig.getTasksPath(), worker.getHost()));
        this.baseStatusPath = this.getPath(Arrays.asList(indexerZkConfig.getStatusPath(), worker.getHost()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        log.info("WorkerCuratorCoordinator good to go. Server[%s]", new Object[]{this.worker.getHost()});
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            CuratorUtils.createIfNotExists((CuratorFramework)this.curatorFramework, (String)this.getTaskPathForWorker(), (CreateMode)CreateMode.PERSISTENT, (byte[])this.jsonMapper.writeValueAsBytes((Object)ImmutableMap.of((Object)"created", (Object)DateTimes.nowUtc().toString())), (int)this.config.getMaxZnodeBytes());
            CuratorUtils.createIfNotExists((CuratorFramework)this.curatorFramework, (String)this.getStatusPathForWorker(), (CreateMode)CreateMode.PERSISTENT, (byte[])this.jsonMapper.writeValueAsBytes((Object)ImmutableMap.of((Object)"created", (Object)DateTimes.nowUtc().toString())), (int)this.config.getMaxZnodeBytes());
            this.announcer.start();
            this.announcer.announce(this.getAnnouncementsPathForWorker(), this.jsonMapper.writeValueAsBytes((Object)this.worker), false);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        log.info("Stopping WorkerCuratorCoordinator for worker[%s]", new Object[]{this.worker.getHost()});
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.announcer.stop();
            this.started = false;
        }
    }

    public String getPath(Iterable<String> parts) {
        return JOINER.join(parts);
    }

    public String getAnnouncementsPathForWorker() {
        return this.baseAnnouncementsPath;
    }

    public String getTaskPathForWorker() {
        return this.baseTaskPath;
    }

    public String getTaskPathForId(String taskId) {
        return this.getPath(Arrays.asList(this.baseTaskPath, taskId));
    }

    public String getStatusPathForWorker() {
        return this.baseStatusPath;
    }

    public String getStatusPathForId(String statusId) {
        return this.getPath(Arrays.asList(this.baseStatusPath, statusId));
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void removeTaskRunZnode(String taskId) throws Exception {
        try {
            ((ChildrenDeletable)this.curatorFramework.delete().guaranteed()).forPath(this.getTaskPathForId(taskId));
        }
        catch (KeeperException e) {
            log.debug((Throwable)e, "Could not delete task path for task[%s]. This is not an error if httpRemote taskRunner is being used at overlord.", new Object[]{taskId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskStatusAnnouncement(TaskAnnouncement announcement) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            CuratorUtils.createOrSet((CuratorFramework)this.curatorFramework, (String)this.getStatusPathForId(announcement.getTaskStatus().getId()), (CreateMode)CreateMode.PERSISTENT, (byte[])this.jsonMapper.writeValueAsBytes((Object)announcement), (int)this.config.getMaxZnodeBytes());
        }
    }

    public List<TaskAnnouncement> getAnnouncements() throws Exception {
        ArrayList<TaskAnnouncement> announcements = new ArrayList<TaskAnnouncement>();
        for (String id : (List)this.curatorFramework.getChildren().forPath(this.getStatusPathForWorker())) {
            announcements.add((TaskAnnouncement)this.jsonMapper.readValue((byte[])this.curatorFramework.getData().forPath(this.getStatusPathForId(id)), TaskAnnouncement.class));
        }
        return announcements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWorkerAnnouncement(Worker newWorker) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                throw new ISE("Cannot update worker! Not Started!", new Object[0]);
            }
            this.worker = newWorker;
            this.announcer.update(this.getAnnouncementsPathForWorker(), this.jsonMapper.writeValueAsBytes((Object)newWorker));
        }
    }
}

