/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;

public class SegmentsAndCommitMetadata {
    private final Object commitMetadata;
    private final ImmutableList<DataSegment> segments;
    private final SegmentSchemaMapping segmentSchemaMapping;
    private final ImmutableSet<DataSegment> upgradedSegments;

    public SegmentsAndCommitMetadata(List<DataSegment> segments, Object commitMetadata) {
        this(segments, commitMetadata, null, null);
    }

    public SegmentsAndCommitMetadata(List<DataSegment> segments, Object commitMetadata, SegmentSchemaMapping segmentSchemaMapping) {
        this(segments, commitMetadata, segmentSchemaMapping, null);
    }

    public SegmentsAndCommitMetadata(List<DataSegment> segments, @Nullable Object commitMetadata, @Nullable SegmentSchemaMapping segmentSchemaMapping, @Nullable Set<DataSegment> upgradedSegments) {
        this.segments = ImmutableList.copyOf(segments);
        this.commitMetadata = commitMetadata;
        this.upgradedSegments = upgradedSegments == null ? null : ImmutableSet.copyOf(upgradedSegments);
        this.segmentSchemaMapping = segmentSchemaMapping;
    }

    public SegmentsAndCommitMetadata withUpgradedSegments(Set<DataSegment> upgradedSegments) {
        return new SegmentsAndCommitMetadata((List<DataSegment>)this.segments, this.commitMetadata, this.segmentSchemaMapping, upgradedSegments);
    }

    @Nullable
    public Object getCommitMetadata() {
        return this.commitMetadata;
    }

    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @Nullable
    public Set<DataSegment> getUpgradedSegments() {
        return this.upgradedSegments;
    }

    public SegmentSchemaMapping getSegmentSchemaMapping() {
        return this.segmentSchemaMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsAndCommitMetadata that = (SegmentsAndCommitMetadata)o;
        return Objects.equals(this.commitMetadata, that.commitMetadata) && Objects.equals(this.upgradedSegments, that.upgradedSegments) && Objects.equals(this.segmentSchemaMapping, that.segmentSchemaMapping) && Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.commitMetadata, this.segments, this.upgradedSegments, this.segmentSchemaMapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{commitMetadata=" + this.commitMetadata + ", segments=" + SegmentUtils.commaSeparatedIdentifiers(this.segments) + ", upgradedSegments=" + SegmentUtils.commaSeparatedIdentifiers(this.upgradedSegments) + ", segmentSchemaMapping=" + this.segmentSchemaMapping + "}";
    }
}

