/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.druid.error.InvalidInput;

public class LookupLoadingSpec {
    public static final String CTX_LOOKUP_LOADING_MODE = "lookupLoadingMode";
    public static final String CTX_LOOKUPS_TO_LOAD = "lookupsToLoad";
    private final Mode mode;
    private final ImmutableSet<String> lookupsToLoad;
    public static final LookupLoadingSpec ALL = new LookupLoadingSpec(Mode.ALL, null);
    public static final LookupLoadingSpec NONE = new LookupLoadingSpec(Mode.NONE, null);

    private LookupLoadingSpec(Mode mode, Set<String> lookupsToLoad) {
        this.mode = mode;
        this.lookupsToLoad = lookupsToLoad == null ? null : ImmutableSet.copyOf(lookupsToLoad);
    }

    public static LookupLoadingSpec loadOnly(Set<String> lookupsToLoad) {
        if (lookupsToLoad == null) {
            throw InvalidInput.exception((String)"Expected non-null set of lookups to load.", (Object[])new Object[0]);
        }
        return new LookupLoadingSpec(Mode.ONLY_REQUIRED, lookupsToLoad);
    }

    public Mode getMode() {
        return this.mode;
    }

    public ImmutableSet<String> getLookupsToLoad() {
        return this.lookupsToLoad;
    }

    public static LookupLoadingSpec createFromContext(Map<String, Object> context, LookupLoadingSpec defaultSpec) {
        Mode lookupLoadingMode;
        if (context == null) {
            return defaultSpec;
        }
        Object lookupModeValue = context.get(CTX_LOOKUP_LOADING_MODE);
        if (lookupModeValue == null) {
            return defaultSpec;
        }
        try {
            lookupLoadingMode = Mode.valueOf(lookupModeValue.toString());
        }
        catch (IllegalArgumentException e) {
            throw InvalidInput.exception((String)"Invalid value of %s[%s]. Allowed values are %s", (Object[])new Object[]{CTX_LOOKUP_LOADING_MODE, lookupModeValue.toString(), Arrays.asList(Mode.values())});
        }
        if (lookupLoadingMode == Mode.NONE) {
            return NONE;
        }
        if (lookupLoadingMode == Mode.ALL) {
            return ALL;
        }
        if (lookupLoadingMode == Mode.ONLY_REQUIRED) {
            Collection lookupsToLoad;
            try {
                lookupsToLoad = (Collection)context.get(CTX_LOOKUPS_TO_LOAD);
            }
            catch (ClassCastException e) {
                throw InvalidInput.exception((String)"Invalid value of %s[%s]. Please provide a comma-separated list of lookup names. For example: [\"lookupName1\", \"lookupName2\"]", (Object[])new Object[]{CTX_LOOKUPS_TO_LOAD, context.get(CTX_LOOKUPS_TO_LOAD)});
            }
            if (lookupsToLoad == null || lookupsToLoad.isEmpty()) {
                throw InvalidInput.exception((String)"Set of lookups to load cannot be %s for mode[ONLY_REQUIRED].", (Object[])new Object[]{lookupsToLoad});
            }
            return LookupLoadingSpec.loadOnly(new HashSet<String>(lookupsToLoad));
        }
        return defaultSpec;
    }

    public String toString() {
        return "LookupLoadingSpec{mode=" + this.mode + ", lookupsToLoad=" + this.lookupsToLoad + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupLoadingSpec that = (LookupLoadingSpec)o;
        return this.mode == that.mode && Objects.equals(this.lookupsToLoad, that.lookupsToLoad);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.lookupsToLoad});
    }

    public static enum Mode {
        ALL,
        NONE,
        ONLY_REQUIRED;

    }
}

