/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.hdfs;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.hdfs.HdfsKerberosConfig;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;

@ManageLifecycle
public class HdfsStorageAuthentication {
    private static final Logger log = new Logger(HdfsStorageAuthentication.class);
    private final HdfsKerberosConfig hdfsKerberosConfig;
    private final Configuration hadoopConf;

    @Inject
    public HdfsStorageAuthentication(HdfsKerberosConfig hdfsKerberosConfig, @Hdfs Configuration hadoopConf) {
        this.hdfsKerberosConfig = hdfsKerberosConfig;
        this.hadoopConf = hadoopConf;
    }

    @LifecycleStart
    public void authenticate() {
        String principal = this.hdfsKerberosConfig.getPrincipal();
        String keytab = this.hdfsKerberosConfig.getKeytab();
        if (!Strings.isNullOrEmpty((String)principal) && !Strings.isNullOrEmpty((String)keytab)) {
            UserGroupInformation.setConfiguration((Configuration)this.hadoopConf);
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    if (!UserGroupInformation.getCurrentUser().hasKerberosCredentials() || !UserGroupInformation.getCurrentUser().getUserName().equals(principal)) {
                        log.info("Trying to authenticate user [%s] with keytab [%s]..", new Object[]{principal, keytab});
                        UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
                    }
                }
                catch (IOException e) {
                    throw new ISE((Throwable)e, "Failed to authenticate user principal [%s] with keytab [%s]", new Object[]{principal, keytab});
                }
            }
        }
    }

    @LifecycleStop
    public void stop() {
    }
}

