/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.DruidException;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.Calcites;

class ReductionOperatorConversionHelper {
    static final SqlReturnTypeInference TYPE_INFERENCE = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        int n = opBinding.getOperandCount();
        if (n == 0) {
            return typeFactory.createSqlType(SqlTypeName.NULL);
        }
        SqlTypeName returnSqlTypeName = SqlTypeName.NULL;
        boolean hasDouble = false;
        for (int i = 0; i < n; ++i) {
            RelDataType type = opBinding.getOperandType(i);
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            Object valueType = SqlTypeName.INTERVAL_TYPES.contains(type.getSqlTypeName()) ? ColumnType.LONG : (SqlTypeName.NULL == type.getSqlTypeName() ? null : Calcites.getColumnTypeForRelDataType(type));
            if (valueType == null) continue;
            if (valueType.is((TypeDescriptor)ValueType.STRING)) {
                returnSqlTypeName = sqlTypeName;
                break;
            }
            if (valueType.anyOf((TypeDescriptor[])new ValueType[]{ValueType.DOUBLE, ValueType.FLOAT})) {
                returnSqlTypeName = SqlTypeName.DOUBLE;
                hasDouble = true;
                continue;
            }
            if (valueType.is((TypeDescriptor)ValueType.LONG)) {
                if (hasDouble) continue;
                returnSqlTypeName = SqlTypeName.BIGINT;
                continue;
            }
            throw DruidException.defensive((String)"Got type[%s], which should have been a validation error.", (Object[])new Object[]{type});
        }
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(returnSqlTypeName), true);
    };
    static final SqlOperandTypeChecker OPERAND_TYPE_CHECKER = new SqlOperandTypeChecker(){

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            for (SqlNode operand : callBinding.operands()) {
                RelDataType type = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
                boolean validType = SqlTypeFamily.STRING.contains(type) || SqlTypeFamily.NUMERIC.contains(type) || SqlTypeFamily.TIMESTAMP.contains(type) || SqlTypeFamily.NULL.contains(type);
                if (validType) continue;
                return OperatorConversions.throwOrReturn(throwOnFailure, callBinding, SqlCallBinding::newValidationSignatureError);
            }
            return true;
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.any();
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return opName + "(<STRING | NUMERIC | DATETIME | BOOLEAN | NULL>, ...)";
        }
    };

    private ReductionOperatorConversionHelper() {
    }
}

