/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.schema.DruidSchemaCatalog;
import org.apache.druid.sql.calcite.schema.NamedSchema;

public class RootSchemaProvider
implements Provider<DruidSchemaCatalog> {
    private final Set<NamedSchema> namedSchemas;
    private final Map<String, NamedSchema> schemasByName;

    @Inject
    RootSchemaProvider(Set<NamedSchema> namedSchemas) {
        this.namedSchemas = namedSchemas;
        this.schemasByName = Maps.newHashMapWithExpectedSize((int)namedSchemas.size());
        for (NamedSchema schema : namedSchemas) {
            if (this.schemasByName.containsKey(schema.getSchemaName())) {
                throw new ISE("Found multiple schemas registered to the same name. The list of registered schemas are %s", new Object[]{namedSchemas.stream().map(NamedSchema::getSchemaName).collect(Collectors.toList())});
            }
            this.schemasByName.put(schema.getSchemaName(), schema);
        }
    }

    public DruidSchemaCatalog get() {
        SchemaPlus rootSchema = CalciteSchema.createRootSchema((boolean)false, (boolean)false).plus();
        for (NamedSchema schema : this.namedSchemas) {
            rootSchema.add(schema.getSchemaName(), schema.getSchema());
        }
        return new DruidSchemaCatalog(rootSchema, (Map<String, NamedSchema>)ImmutableMap.copyOf(this.schemasByName));
    }
}

