/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.parquet.simple.ParquetGroupFlattenerMaker;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;

public class ParquetReader
extends IntermediateRowParsingReader<Group> {
    private final Configuration conf;
    private final InputRowSchema inputRowSchema;
    private final InputEntity source;
    private final File temporaryDirectory;
    private final ObjectFlattener<Group> flattener;

    ParquetReader(Configuration conf, InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory, @Nullable JSONPathSpec flattenSpec, boolean binaryAsString) {
        this.conf = conf;
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.temporaryDirectory = temporaryDirectory;
        this.flattener = ObjectFlatteners.create((JSONPathSpec)flattenSpec, (ObjectFlatteners.FlattenerMaker)new ParquetGroupFlattenerMaker(binaryAsString, inputRowSchema.getDimensionsSpec().useSchemaDiscovery()));
    }

    protected CloseableIterator<Group> intermediateRowIterator() throws IOException {
        org.apache.parquet.hadoop.ParquetReader reader;
        final Closer closer = Closer.create();
        byte[] buffer = new byte[4096];
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            InputEntity.CleanableFile file = (InputEntity.CleanableFile)closer.register((Closeable)this.source.fetch(this.temporaryDirectory, buffer));
            Path path = new Path(file.file().toURI());
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            reader = (org.apache.parquet.hadoop.ParquetReader)closer.register((Closeable)org.apache.parquet.hadoop.ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)path).withConf(this.conf).build());
        }
        catch (Exception e) {
            closer.close();
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return new CloseableIterator<Group>(){
            Group value = null;

            public boolean hasNext() {
                if (this.value == null) {
                    try {
                        this.value = (Group)reader.read();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.value != null;
            }

            public Group next() {
                if (this.value == null) {
                    throw new NoSuchElementException();
                }
                Group currentValue = this.value;
                this.value = null;
                return currentValue;
            }

            public void close() throws IOException {
                closer.close();
            }
        };
    }

    protected InputEntity source() {
        return this.source;
    }

    protected List<InputRow> parseInputRows(Group intermediateRow) throws ParseException {
        return Collections.singletonList(MapInputRowParser.parse((InputRowSchema)this.inputRowSchema, (Map)this.flattener.flatten((Object)intermediateRow)));
    }

    protected List<Map<String, Object>> toMap(Group intermediateRow) {
        return Collections.singletonList(this.flattener.toMap((Object)intermediateRow));
    }
}

