/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.druid.security.basic.BasicSecurityDBResourceException;
import org.apache.druid.server.security.ResourceAction;

public class BasicAuthorizerPermission {
    private final ResourceAction resourceAction;
    private final Pattern resourceNamePattern;

    @JsonCreator
    public BasicAuthorizerPermission(@JsonProperty(value="resourceAction") ResourceAction resourceAction, @JsonProperty(value="resourceNamePattern") Pattern resourceNamePattern) {
        this.resourceAction = resourceAction;
        this.resourceNamePattern = resourceNamePattern;
    }

    private BasicAuthorizerPermission(ResourceAction resourceAction) {
        this.resourceAction = resourceAction;
        try {
            this.resourceNamePattern = Pattern.compile(resourceAction.getResource().getName());
        }
        catch (PatternSyntaxException pse) {
            throw new BasicSecurityDBResourceException(pse, "Invalid permission, resource name regex[%s] does not compile.", resourceAction.getResource().getName());
        }
    }

    @JsonProperty
    public ResourceAction getResourceAction() {
        return this.resourceAction;
    }

    @JsonProperty
    public Pattern getResourceNamePattern() {
        return this.resourceNamePattern;
    }

    public static List<BasicAuthorizerPermission> makePermissionList(List<ResourceAction> resourceActions) {
        ArrayList<BasicAuthorizerPermission> permissions = new ArrayList<BasicAuthorizerPermission>();
        if (resourceActions == null) {
            return permissions;
        }
        for (ResourceAction resourceAction : resourceActions) {
            permissions.add(new BasicAuthorizerPermission(resourceAction));
        }
        return permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuthorizerPermission that = (BasicAuthorizerPermission)o;
        if (this.getResourceAction() != null ? !this.getResourceAction().equals((Object)that.getResourceAction()) : that.getResourceAction() != null) {
            return false;
        }
        return this.getResourceNamePattern() != null ? this.getResourceNamePattern().pattern().equals(that.getResourceNamePattern().pattern()) : that.getResourceNamePattern() == null;
    }

    public int hashCode() {
        int result = this.getResourceAction() != null ? this.getResourceAction().hashCode() : 0;
        result = 31 * result + (this.getResourceNamePattern().pattern() != null ? this.getResourceNamePattern().pattern().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "BasicAuthorizerPermission{resourceAction=" + this.resourceAction + ", resourceNamePattern=" + this.resourceNamePattern + "}";
    }
}

