/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.portfolio.savings.api.SavingsAccountTransactionsApiResource;
import org.springframework.stereotype.Component;

@Component
public class SavingsAccountAdjustTransactionCommandStrategy
implements CommandStrategy {
    private final SavingsAccountTransactionsApiResource savingsAccountTransactionsApiResource;

    public BatchResponse execute(BatchRequest batchRequest, UriInfo uriInfo) {
        List pathParameters;
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)batchRequest);
        String command = null;
        if (relativeUrl.indexOf(63) > 0) {
            String subString = StringUtils.substringBefore((String)relativeUrl, (String)"?");
            pathParameters = Splitter.on((char)'/').splitToList((CharSequence)subString);
            Map queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            command = (String)queryParameters.get("command");
        } else {
            pathParameters = Splitter.on((char)'/').splitToList((CharSequence)relativeUrl);
        }
        Long savingsAccountId = Long.parseLong((String)pathParameters.get(1));
        Long transactionId = Long.parseLong((String)pathParameters.get(3));
        String responseBody = this.savingsAccountTransactionsApiResource.adjustTransaction(savingsAccountId, transactionId, command, batchRequest.getBody());
        return new BatchResponse().setRequestId(batchRequest.getRequestId()).setStatusCode(Integer.valueOf(200)).setBody(responseBody).setHeaders(batchRequest.getHeaders());
    }

    @Generated
    public SavingsAccountAdjustTransactionCommandStrategy(SavingsAccountTransactionsApiResource savingsAccountTransactionsApiResource) {
        this.savingsAccountTransactionsApiResource = savingsAccountTransactionsApiResource;
    }
}

