/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.codes.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.codes.CodeConstants;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class CodeValueCommandFromApiJsonDeserializer {
    private static final Set<String> SUPPORTED_PARAMETERS = CodeConstants.CodevalueJSONinputParams.getAllValues();
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CodeValueCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("code.value");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String name = this.fromApiJsonHelper.extractStringNamed(CodeConstants.CodevalueJSONinputParams.NAME.getValue(), element);
        baseDataValidator.reset().parameter(CodeConstants.CodevalueJSONinputParams.NAME.getValue()).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue(), element)) {
            String description = this.fromApiJsonHelper.extractStringNamed(CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue(), element);
            baseDataValidator.reset().parameter(CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue()).value((Object)description).notExceedingLengthOf(Integer.valueOf(500));
        }
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.POSITION.getValue(), element)) {
            this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CodeConstants.CodevalueJSONinputParams.POSITION.getValue(), element);
        }
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.IS_ACTIVE.getValue(), element)) {
            Boolean isActive = this.fromApiJsonHelper.extractBooleanNamed(CodeConstants.CodevalueJSONinputParams.IS_ACTIVE.getValue(), element);
            baseDataValidator.reset().parameter(CodeConstants.CodevalueJSONinputParams.IS_ACTIVE.getValue()).value((Object)isActive).validateForBooleanValue();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("code.value");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.NAME.getValue(), element)) {
            String name = this.fromApiJsonHelper.extractStringNamed(CodeConstants.CodevalueJSONinputParams.NAME.getValue(), element);
            baseDataValidator.reset().parameter(CodeConstants.CodevalueJSONinputParams.NAME.getValue()).value((Object)name).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue(), element)) {
            String description = this.fromApiJsonHelper.extractStringNamed(CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue(), element);
            baseDataValidator.reset().parameter(CodeConstants.CodevalueJSONinputParams.DESCRIPTION.getValue()).value((Object)description).notExceedingLengthOf(Integer.valueOf(500));
        }
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.POSITION.getValue(), element)) {
            this.fromApiJsonHelper.extractIntegerSansLocaleNamed(CodeConstants.CodevalueJSONinputParams.POSITION.getValue(), element);
        }
        if (this.fromApiJsonHelper.parameterExists(CodeConstants.CodevalueJSONinputParams.IS_ACTIVE.getValue(), element)) {
            Boolean isActive = this.fromApiJsonHelper.extractBooleanNamed(CodeConstants.CodevalueJSONinputParams.IS_ACTIVE.getValue(), element);
            baseDataValidator.reset().parameter(CodeConstants.CodevalueJSONinputParams.IS_ACTIVE.getValue()).value((Object)isActive).validateForBooleanValue();
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

