/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config;

import com.google.common.base.Strings;
import java.net.URI;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Configuration
public class ContentS3Config {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContentS3Config.class);

    @Bean
    @ConditionalOnProperty(value={"fineract.content.s3.enabled"})
    public S3Client contentS3Client(FineractProperties fineractProperties) {
        S3ClientBuilder builder = (S3ClientBuilder)S3Client.builder().credentialsProvider(this.getCredentialProvider(fineractProperties.getContent().getS3()));
        if (!Strings.isNullOrEmpty((String)fineractProperties.getContent().getS3().getRegion())) {
            builder.region(Region.of((String)fineractProperties.getContent().getS3().getRegion()));
        }
        if (!Strings.isNullOrEmpty((String)fineractProperties.getContent().getS3().getEndpoint())) {
            ((S3ClientBuilder)builder.endpointOverride(URI.create(fineractProperties.getContent().getS3().getEndpoint()))).forcePathStyle(fineractProperties.getContent().getS3().getPathStyleAddressingEnabled());
        }
        return (S3Client)builder.build();
    }

    private AwsCredentialsProvider getCredentialProvider(FineractProperties.FineractContentS3Properties s3Properties) {
        if (Strings.isNullOrEmpty((String)s3Properties.getAccessKey()) || Strings.isNullOrEmpty((String)s3Properties.getSecretKey())) {
            return DefaultCredentialsProvider.create();
        }
        return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)s3Properties.getAccessKey(), (String)s3Properties.getSecretKey()));
    }
}

