/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config.cache;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.config.cache.SpecifiedCacheSupportingCacheManager;
import org.apache.fineract.infrastructure.core.config.cache.TransactionBoundCacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.cache.support.NoOpCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
public class CacheConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheConfig.class);
    public static final String CONFIG_BY_NAME_CACHE_NAME = "configByName";
    @Autowired
    private FineractProperties fineractProperties;

    @Bean
    public TransactionBoundCacheManager defaultCacheManager(JCacheCacheManager ehCacheManager) {
        SpecifiedCacheSupportingCacheManager cacheManager = new SpecifiedCacheSupportingCacheManager();
        cacheManager.setNoOpCacheManager(new NoOpCacheManager());
        cacheManager.setDelegateCacheManager(ehCacheManager);
        cacheManager.setSupportedCaches(new String[]{"configByName"});
        return new TransactionBoundCacheManager((org.springframework.cache.CacheManager)cacheManager);
    }

    @Bean
    public JCacheCacheManager ehCacheManager() {
        JCacheCacheManager jCacheCacheManager = new JCacheCacheManager();
        jCacheCacheManager.setCacheManager(this.getInternalEhCacheManager());
        return jCacheCacheManager;
    }

    private CacheManager getInternalEhCacheManager() {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager cacheManager = provider.getCacheManager();
        Duration defaultTimeToLive = this.fineractProperties.getCache().getDefaultTemplate().getTtl();
        Integer defaultMaxEntries = this.fineractProperties.getCache().getDefaultTemplate().getMaximumEntries();
        javax.cache.configuration.Configuration defaultTemplate = CacheConfig.generateCacheConfiguration((Integer)defaultMaxEntries, (Duration)defaultTimeToLive);
        Reflections reflections = new Reflections((org.reflections.Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forJavaClassPath()).addScanners(new Scanner[]{Scanners.MethodsAnnotated, Scanners.TypesAnnotated}));
        Set annotatedMethods = reflections.getMethodsAnnotatedWith(Cacheable.class);
        Set<String> cacheNames = annotatedMethods.stream().map(method -> method.getAnnotation(Cacheable.class)).flatMap(annotation -> Stream.concat(Arrays.stream(annotation.value()), Arrays.stream(annotation.cacheNames()))).collect(Collectors.toSet());
        Set annotatedClasses = reflections.getTypesAnnotatedWith(Cacheable.class);
        cacheNames.addAll(annotatedClasses.stream().map(clazz -> clazz.getAnnotation(Cacheable.class)).flatMap(annotation -> Stream.concat(Arrays.stream(annotation.value()), Arrays.stream(annotation.cacheNames()))).collect(Collectors.toSet()));
        Set annotatedCacheConfigClasses = reflections.getTypesAnnotatedWith(org.springframework.cache.annotation.CacheConfig.class);
        cacheNames.addAll(annotatedCacheConfigClasses.stream().map(clazz -> clazz.getAnnotation(org.springframework.cache.annotation.CacheConfig.class)).flatMap(annotation -> Arrays.stream(annotation.cacheNames())).collect(Collectors.toSet()));
        cacheNames.forEach(cacheName -> {
            if (cacheManager.getCache(cacheName) == null) {
                javax.cache.configuration.Configuration configurationTemplate = this.generateCustomCacheConfiguration(cacheName, defaultTemplate, defaultTimeToLive, defaultMaxEntries);
                cacheManager.createCache(cacheName, configurationTemplate);
            }
        });
        HashSet incorrectConfigurations = new HashSet(this.fineractProperties.getCache().getCustomTemplates().keySet());
        incorrectConfigurations.removeAll(cacheNames);
        if (!incorrectConfigurations.isEmpty()) {
            log.warn("The following cache configurations are defined but cache does not exists: {}", incorrectConfigurations);
        }
        return cacheManager;
    }

    private javax.cache.configuration.Configuration<Object, Object> generateCustomCacheConfiguration(String cacheIdentifier, javax.cache.configuration.Configuration<Object, Object> defaultTemplate, Duration defaultTimeToLive, Integer defaultMaxEntries) {
        javax.cache.configuration.Configuration configurationTemplate = defaultTemplate;
        if (this.fineractProperties.getCache().getCustomTemplates().containsKey(cacheIdentifier)) {
            Duration timeToLiveExpiration = Objects.requireNonNullElse(((FineractProperties.FineractCacheDetails)this.fineractProperties.getCache().getCustomTemplates().get(cacheIdentifier)).getTtl(), defaultTimeToLive);
            Integer maxEntries = Objects.requireNonNullElse(((FineractProperties.FineractCacheDetails)this.fineractProperties.getCache().getCustomTemplates().get(cacheIdentifier)).getMaximumEntries(), defaultMaxEntries);
            configurationTemplate = CacheConfig.generateCacheConfiguration((Integer)maxEntries, (Duration)timeToLiveExpiration);
        }
        return configurationTemplate;
    }

    private static javax.cache.configuration.Configuration<Object, Object> generateCacheConfiguration(Integer defaultMaxEntries, Duration defaultTimeToLive) {
        return Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)defaultMaxEntries.intValue())).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)defaultTimeToLive)).build());
    }
}

