/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.output;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.fineract.infrastructure.core.diagnostics.performance.sampling.core.SamplingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SamplingDataPrinter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SamplingDataPrinter.class);

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"})
    public void print(Map<Class<?>, SamplingData> data) {
        String logMsg;
        if (log.isInfoEnabled() && MapUtils.isNotEmpty(data) && StringUtils.isNotBlank((CharSequence)(logMsg = data.entrySet().stream().map(e -> this.getFormattedSamplingData((Class)e.getKey(), (SamplingData)e.getValue())).filter(Objects::nonNull).collect(Collectors.joining(System.lineSeparator()))))) {
            log.info(logMsg);
        }
    }

    @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
    private String getFormattedSamplingData(Class<?> clazz, SamplingData samplingData) {
        Map timings;
        if (clazz != null && samplingData != null && !(timings = samplingData.getTimings()).isEmpty()) {
            return "\nSampling data for %s\n-------------\n%s\n".formatted(clazz.getName(), this.getTimingsLog(timings));
        }
        return null;
    }

    private String getTimingsLog(Map<String, List<Duration>> timings) {
        return timings.entrySet().stream().map(e -> this.getSingleTimingLog((String)e.getKey(), (List)e.getValue())).collect(Collectors.joining(System.lineSeparator()));
    }

    private String getSingleTimingLog(String key, List<Duration> durations) {
        double[] millis = durations.stream().mapToLong(Duration::toMillis).asDoubleStream().toArray();
        double percentile99 = StatUtils.percentile((double[])millis, (double)99.0);
        double average = Arrays.stream(millis).average().orElse(Double.NaN);
        double median = StatUtils.percentile((double[])millis, (double)50.0);
        double lowest = StatUtils.min((double[])millis);
        return "%s with %d data points -> 99th percentile: %.0fms, average: %.0fms, median: %.0fms, lowest: %.0fms".formatted(key, millis.length, percentile99, average, median, lowest);
    }
}

