/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.springframework.stereotype.Component;

@Component
public class OffsetDateTimeJsonConverter
implements JsonConverter<OffsetDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME;

    public OffsetDateTime convertToObject(JsonParser parser) throws IOException {
        OffsetDateTime result = null;
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            String formattedDate = parser.getText();
            result = OffsetDateTime.parse(formattedDate, FORMATTER);
        }
        return result;
    }

    public void convertToJson(OffsetDateTime value, JsonGenerator generator) throws IOException {
        if (value != null) {
            generator.writeString(FORMATTER.format(value));
        }
    }

    public Class<OffsetDateTime> convertedType() {
        return OffsetDateTime.class;
    }
}

