/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.data;

import java.util.Collection;
import org.apache.fineract.infrastructure.creditbureau.data.CreditReportData;
import org.apache.fineract.infrastructure.creditbureau.data.CreditReportReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.creditbureau.service.CreditReportReadPlatformService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class CreditReportReadPlatformServiceImpl
implements CreditReportReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;

    @Autowired
    public CreditReportReadPlatformServiceImpl(PlatformSecurityContext context, JdbcTemplate jdbcTemplate) {
        this.context = context;
        this.jdbcTemplate = jdbcTemplate;
    }

    public Collection<CreditReportData> retrieveCreditReportDetails(Long creditBureauId) {
        this.context.authenticatedUser();
        CreditReportDataMapper rm = new CreditReportDataMapper();
        String sql = " select " + rm.schema() + " where c.creditBureauId = ? ";
        return this.jdbcTemplate.query(sql, (RowMapper)rm, new Object[]{creditBureauId});
    }
}

