/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.exception.PlatformServiceUnavailableException;
import org.apache.fineract.infrastructure.dataqueries.api.RunreportsApiResourceSwagger;
import org.apache.fineract.infrastructure.dataqueries.data.ReportExportType;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.report.provider.ReportingProcessServiceProvider;
import org.apache.fineract.infrastructure.report.service.ReportingProcessService;
import org.apache.fineract.infrastructure.security.exception.NoAuthorizationException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.domain.AppUser;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.springframework.stereotype.Component;

@Path(value="/v1/runreports")
@Component
@Tag(name="Run Reports", description="API for executing predefined reports with dynamic parameters")
public class RunreportsApiResource {
    public static final String IS_SELF_SERVICE_USER_REPORT_PARAMETER = "isSelfServiceUserReport";
    private final PlatformSecurityContext context;
    private final ReadReportingService readExtraDataAndReportingService;
    private final ReportingProcessServiceProvider reportingProcessServiceProvider;

    @GET
    @Path(value="/availableExports/{reportName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Return all available export types for the specific report", description="Returns the list of all available export types for a given report.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ReportExportType.class)))}), @ApiResponse(responseCode="400", description="Bad Request - Invalid report name or parameters"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Response retrieveAllAvailableExports(@PathParam(value="reportName") @Parameter(description="Name of the report to get available export types for", example="Client Listing", required=true) String reportName, @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="isSelfServiceUserReport") @Parameter(description="Indicates if this is a self-service user report", example="false") boolean isSelfServiceUserReport) {
        MultivaluedStringMap queryParams = new MultivaluedStringMap();
        queryParams.putAll((Map)uriInfo.getQueryParameters());
        boolean parameterType = ApiParameterHelper.parameterType((MultivaluedMap)queryParams);
        String reportType = this.readExtraDataAndReportingService.getReportType(reportName, isSelfServiceUserReport, parameterType);
        ReportingProcessService reportingProcessService = this.reportingProcessServiceProvider.findReportingProcessService(reportType);
        if (reportingProcessService == null) {
            throw new PlatformServiceUnavailableException("err.msg.report.service.implementation.missing", "There is no ReportingProcessService registered in the ReportingProcessServiceProvider for this report type: " + reportType, new Object[]{reportType});
        }
        return Response.ok().entity((Object)reportingProcessService.getAvailableExportTargets()).build();
    }

    @GET
    @Path(value="{reportName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/csv", "application/vnd.ms-excel", "application/pdf", "text/html"})
    @Operation(summary="Run a predefined report", description="This resource allows you to run and receive output from pre-defined Apache Fineract reports.\n\nReports can also be used to provide data for searching and workflow functionality.\n\nThe default output is a JSON formatted \"Generic Resultset\". The Generic Resultset contains Column Heading as well as Data information. However, you can export to CSV format by simply adding \"&exportCSV=true\" to the end of your URL.\n\nIf Pentaho reports have been pre-defined, they can also be run through this resource. Pentaho reports can return HTML, PDF or CSV formats.\n\nThe Apache Fineract reference application uses a JQuery plugin called stretchy reporting which, itself, uses this reports resource to provide a pretty flexible reporting User Interface (UI).\n\n\n\nExample Requests:\n\nrunreports/Client%20Listing?R_officeId=1\n\n\nrunreports/Client%20Listing?R_officeId=1&exportCSV=true\n\n\nrunreports/OfficeIdSelectOne?R_officeId=1&parameterType=true\n\n\nrunreports/OfficeIdSelectOne?R_officeId=1&parameterType=true&exportCSV=true\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=HTML&R_officeId=1\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=XLS&R_officeId=1\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=CSV&R_officeId=1\n\n\nrunreports/Expected%20Payments%20By%20Date%20-%20Formatted?R_endDate=2013-04-30&R_loanOfficerId=-1&R_officeId=1&R_startDate=2013-04-16&output-type=PDF&R_officeId=1\n\n**Available Parameters (All Optional):**\n\n**Common Control Parameters:**\n- `isSelfServiceUserReport`: Indicates if this is a self-service user report (default: false)\n- `exportCSV`: Set to true to export results as CSV (default: false)\n- `parameterType`: Indicates if this is a parameter type request (default: false)\n- `output-type`: Output format type (HTML, XLS, CSV, PDF)\n- `enable-business-date`: Enable business date filtering\n- `obligDateType`: Obligation date type\n- `decimalChoice`: Decimal formatting choice\n- `Portfolio at Risk by Branch`: Portfolio risk parameter\n\n**Common Report Parameters (R_ prefixed):**\n- `R_officeId`: Office ID filter\n- `R_loanOfficerId`: Loan officer ID filter\n- `R_currencyId`: Currency ID filter\n- `R_fromDate`, `R_toDate`: Date range filters (yyyy-MM-dd)\n- `R_accountNo`: Account number filter\n- `R_transactionId`: Transaction ID filter\n- `R_centerId`: Center ID filter\n- `R_branch`: Branch filter\n- `R_ondate`: Specific date filter\n- `R_cycleX`, `R_cycleY`: Cycle filters\n- `R_fromX`, `R_toY`: Range filters\n- `R_overdueX`, `R_overdueY`: Overdue filters\n- `R_endDate`: End date filter\n\n**Other Common Parameters:**\n- `OfficeId`: Office ID filter (alternative)\n- `loanOfficerId`: Loan officer ID filter (alternative)\n- `currencyId`: Currency ID filter (alternative)\n- `fundId`: Fund ID filter\n- `loanProductId`: Loan product ID filter\n- `loanPurposeId`: Loan purpose ID filter\n- `parType`: Portfolio at risk type\n- `SelectGLAccountNO`: GL account number selection\n- `SavingsAccountSubStatus`: Savings account status\n- `SelectLoanType`: Loan type selection\n\n**Note:** All parameters are optional and report-specific. \nThe exact parameters required depend on the specific report being executed.\nSome reports may accept additional parameters not listed here.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK - Report executed successfully", content={@Content(schema=@Schema(implementation=RunreportsApiResourceSwagger.RunReportsResponse.class))}), @ApiResponse(responseCode="400", description="Bad Request - Missing or invalid parameters"), @ApiResponse(responseCode="401", description="Unauthorized - Not authorized to run this report"), @ApiResponse(responseCode="500", description="Internal Server Error")})
    public Response runReport(@PathParam(value="reportName") @Parameter(description="The name of the report to execute (e.g., 'Client Listing', 'Expected Payments By Date')", example="Client Listing", required=true) String reportName, @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="isSelfServiceUserReport") @Parameter(description="Whether this is a self-service user report", example="false") boolean isSelfServiceUserReport, @DefaultValue(value="false") @QueryParam(value="exportCSV") @Parameter(description="Set to true to export results as CSV", example="false") Boolean exportCSV, @DefaultValue(value="false") @QueryParam(value="parameterType") @Parameter(description="Indicates if this is a parameter type request", example="false") Boolean parameterType, @QueryParam(value="output-type") @Parameter(description="Output format type (HTML, XLS, CSV, PDF)", example="HTML") String outputType, @QueryParam(value="R_officeId") @Parameter(description="Office ID filter", example="1") String rOfficeId, @QueryParam(value="R_loanOfficerId") @Parameter(description="Loan officer ID filter", example="5") String rLoanOfficerId, @QueryParam(value="R_fromDate") @Parameter(description="Start date filter (yyyy-MM-dd)", example="2023-01-01") String rFromDate, @QueryParam(value="R_toDate") @Parameter(description="End date filter (yyyy-MM-dd)", example="2023-12-31") String rToDate, @QueryParam(value="R_currencyId") @Parameter(description="Currency ID filter", example="USD") String rCurrencyId, @QueryParam(value="R_accountNo") @Parameter(description="Account number filter", example="00010001") String rAccountNo) {
        return this.processReportRequest(reportName, uriInfo, isSelfServiceUserReport);
    }

    public Response runReport(String reportName, UriInfo uriInfo, boolean isSelfServiceUserReport) {
        return this.processReportRequest(reportName, uriInfo, isSelfServiceUserReport);
    }

    private Response processReportRequest(String reportName, UriInfo uriInfo, boolean isSelfServiceUserReport) {
        MultivaluedStringMap queryParams = new MultivaluedStringMap();
        queryParams.putAll((Map)uriInfo.getQueryParameters());
        boolean parameterTypeValue = ApiParameterHelper.parameterType((MultivaluedMap)queryParams);
        this.checkUserPermissionForReport(reportName, parameterTypeValue);
        queryParams.putSingle((Object)IS_SELF_SERVICE_USER_REPORT_PARAMETER, (Object)Boolean.toString(isSelfServiceUserReport));
        String reportType = this.readExtraDataAndReportingService.getReportType(reportName, isSelfServiceUserReport, parameterTypeValue);
        ReportingProcessService reportingProcessService = this.reportingProcessServiceProvider.findReportingProcessService(reportType);
        if (reportingProcessService == null) {
            throw new PlatformServiceUnavailableException("err.msg.report.service.implementation.missing", "There is no ReportingProcessService registered in the ReportingProcessServiceProvider for this report type: " + reportType, new Object[]{reportType});
        }
        return reportingProcessService.processRequest(reportName, (MultivaluedMap)queryParams);
    }

    private void checkUserPermissionForReport(String reportName, boolean parameterType) {
        AppUser currentUser;
        if (!parameterType && (currentUser = this.context.authenticatedUser()).hasNotPermissionForReport(reportName)) {
            throw new NoAuthorizationException("Not authorised to run report: " + reportName);
        }
    }

    @Generated
    public RunreportsApiResource(PlatformSecurityContext context, ReadReportingService readExtraDataAndReportingService, ReportingProcessServiceProvider reportingProcessServiceProvider) {
        this.context = context;
        this.readExtraDataAndReportingService = readExtraDataAndReportingService;
        this.reportingProcessServiceProvider = reportingProcessServiceProvider;
    }
}

