/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service;

import com.google.common.base.Splitter;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.PagedLocalRequest;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.core.service.database.SqlOperator;
import org.apache.fineract.infrastructure.dataqueries.data.DataTableValidator;
import org.apache.fineract.infrastructure.dataqueries.data.DatatableData;
import org.apache.fineract.infrastructure.dataqueries.data.EntityTables;
import org.apache.fineract.infrastructure.dataqueries.data.GenericResultsetData;
import org.apache.fineract.infrastructure.dataqueries.data.ResultsetColumnHeaderData;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableReadService;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableUtil;
import org.apache.fineract.infrastructure.dataqueries.service.GenericDataService;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.portfolio.search.data.AdvancedQueryData;
import org.apache.fineract.portfolio.search.service.SearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.NonNull;
import org.springframework.transaction.annotation.Transactional;

public class DatatableReadServiceImpl
implements DatatableReadService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatatableReadServiceImpl.class);
    private static final String APPLICATION_TABLE_NAME = "application_table_name";
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PlatformSecurityContext context;
    private final GenericDataService genericDataService;
    private final DataTableValidator dataTableValidator;
    private final SqlValidator sqlValidator;
    private final SearchUtil searchUtil;
    private final DatatableUtil datatableUtil;

    public List<DatatableData> retrieveDatatableNames(String appTable) {
        Object[] params;
        Object sql = "select application_table_name, registered_table_name, entity_subtype from x_registered_table where exists (select 'f' from m_appuser_role ur join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = ? and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name))) ";
        if (appTable != null) {
            sql = (String)sql + " and application_table_name like ? ";
            params = new Object[]{this.context.authenticatedUser().getId(), appTable};
        } else {
            params = new Object[]{this.context.authenticatedUser().getId()};
        }
        sql = (String)sql + " order by application_table_name, registered_table_name";
        ArrayList<DatatableData> datatables = new ArrayList<DatatableData>();
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet((String)sql, params);
        while (rowSet.next()) {
            String appTableName = rowSet.getString(APPLICATION_TABLE_NAME);
            String registeredDatatableName = rowSet.getString("registered_table_name");
            String entitySubType = rowSet.getString("entity_subtype");
            List columnHeaderData = this.genericDataService.fillResultsetColumnHeaders(registeredDatatableName);
            datatables.add(DatatableData.create((String)appTableName, (String)registeredDatatableName, (String)entitySubType, (List)columnHeaderData));
        }
        return datatables;
    }

    public DatatableData retrieveDatatable(String datatable) {
        this.sqlValidator.validate(datatable);
        String sql = "select application_table_name, registered_table_name, entity_subtype from x_registered_table  where exists (select 'f' from m_appuser_role ur join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = ? and registered_table_name=? and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name)))  order by application_table_name, registered_table_name";
        DatatableData datatableData = null;
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet("select application_table_name, registered_table_name, entity_subtype from x_registered_table  where exists (select 'f' from m_appuser_role ur join m_role r on r.id = ur.role_id left join m_role_permission rp on rp.role_id = r.id left join m_permission p on p.id = rp.permission_id where ur.appuser_id = ? and registered_table_name=? and (p.code in ('ALL_FUNCTIONS', 'ALL_FUNCTIONS_READ') or p.code = concat('READ_', registered_table_name)))  order by application_table_name, registered_table_name", new Object[]{this.context.authenticatedUser().getId(), datatable});
        if (rowSet.next()) {
            String appTableName = rowSet.getString(APPLICATION_TABLE_NAME);
            String registeredDatatableName = rowSet.getString("registered_table_name");
            String entitySubType = rowSet.getString("entity_subtype");
            List columnHeaderData = this.genericDataService.fillResultsetColumnHeaders(registeredDatatableName);
            datatableData = DatatableData.create((String)appTableName, (String)registeredDatatableName, (String)entitySubType, (List)columnHeaderData);
        }
        return datatableData;
    }

    public List<JsonObject> queryDataTable(@NonNull String datatable, @NonNull String columnName, String columnValueString, @NonNull String resultColumnsString) {
        datatable = this.datatableUtil.validateDatatableRegistered(datatable);
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)this.genericDataService.fillResultsetColumnHeaders(datatable));
        List<String> resultColumns = Arrays.asList(resultColumnsString.split(","));
        List selectColumns = this.searchUtil.validateToJdbcColumnNames(resultColumns, headersByName, false);
        ResultsetColumnHeaderData column = this.searchUtil.validateToJdbcColumn(columnName, headersByName, false);
        Object columnValue = this.searchUtil.parseJdbcColumnValue(column, columnValueString, null, null, null, false, this.sqlGenerator);
        String sql = this.sqlGenerator.buildSelect((Collection)selectColumns, null, false) + " " + this.sqlGenerator.buildFrom(datatable, null, false) + " WHERE " + SqlOperator.EQ.formatPlaceholder(this.sqlGenerator, column.getColumnName(), 1, null);
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(sql, new Object[]{columnValue});
        ArrayList<JsonObject> results = new ArrayList<JsonObject>();
        while (rowSet.next()) {
            this.searchUtil.extractJsonResult(rowSet, selectColumns, resultColumns, results);
        }
        return results;
    }

    public Page<JsonObject> queryDataTableAdvanced(@NonNull String datatable, @NonNull PagedLocalRequest<AdvancedQueryData> pagedRequest) {
        PageRequest sortPageable;
        ArrayList<String> selectColumns;
        datatable = this.datatableUtil.validateDatatableRegistered(datatable);
        this.context.authenticatedUser().validateHasDatatableReadPermission(datatable);
        AdvancedQueryData request = (AdvancedQueryData)pagedRequest.getRequest().orElseThrow();
        this.dataTableValidator.validateTableSearch(request);
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)this.genericDataService.fillResultsetColumnHeaders(datatable));
        String pkColumn = this.searchUtil.getFiltered(headersByName.values(), ResultsetColumnHeaderData::getIsColumnPrimaryKey).getColumnName();
        List columnFilters = request.getNonNullFilters();
        columnFilters.forEach(e -> e.setColumn(this.searchUtil.validateToJdbcColumnName(e.getColumn(), headersByName, false)));
        List resultColumns = request.getNonNullResultColumns();
        if (resultColumns.isEmpty()) {
            resultColumns.add(pkColumn);
            selectColumns = new ArrayList<String>();
            selectColumns.add(pkColumn);
        } else {
            selectColumns = this.searchUtil.validateToJdbcColumnNames(resultColumns, headersByName, false);
        }
        PageRequest pageable = pagedRequest.toPageable();
        if (pageable.getSort().isSorted()) {
            List orders = pageable.getSort().toList();
            sortPageable = pageable.withSort(Sort.by(orders.stream().map(e -> e.withProperty(this.searchUtil.validateToJdbcColumnName(e.getProperty(), headersByName, false))).toList()));
        } else {
            sortPageable = pageable = pageable.withSort(Sort.Direction.DESC, new String[]{pkColumn});
        }
        String dateFormat = pagedRequest.getDateFormat();
        String dateTimeFormat = pagedRequest.getDateTimeFormat();
        Locale locale = pagedRequest.getLocaleObject();
        String select = this.sqlGenerator.buildSelect(selectColumns, null, false);
        String from = " " + this.sqlGenerator.buildFrom(datatable, null, false);
        StringBuilder where = new StringBuilder();
        ArrayList params = new ArrayList();
        this.searchUtil.buildQueryCondition(columnFilters, where, params, null, headersByName, dateFormat, dateTimeFormat, locale, false, this.sqlGenerator);
        ArrayList results = new ArrayList();
        Object[] args = params.toArray();
        String countQuery = "SELECT COUNT(*)" + from + String.valueOf(where);
        Integer totalElements = (Integer)this.jdbcTemplate.queryForObject(countQuery, Integer.class, args);
        if (totalElements == null || totalElements == 0) {
            return PageableExecutionUtils.getPage(results, (Pageable)pageable, () -> 0L);
        }
        StringBuilder query = new StringBuilder().append(select).append(from).append((CharSequence)where);
        query.append(" ").append(this.sqlGenerator.buildOrderBy(sortPageable.getSort().toList(), null, false));
        if (pageable.isPaged()) {
            query.append(" ").append(this.sqlGenerator.limit(pageable.getPageSize(), (int)pageable.getOffset()));
        }
        SqlRowSet rowSet = this.jdbcTemplate.queryForRowSet(query.toString(), args);
        while (rowSet.next()) {
            this.searchUtil.extractJsonResult(rowSet, selectColumns, resultColumns, results);
        }
        return PageableExecutionUtils.getPage(results, (Pageable)pageable, () -> totalElements.intValue());
    }

    public boolean buildDataQueryEmbedded(@NonNull EntityTables entityTable, @NonNull String datatable, @NonNull AdvancedQueryData request, @NonNull List<String> selectColumns, @NonNull StringBuilder select, @NonNull StringBuilder from, @NonNull StringBuilder where, @NonNull List<Object> params, String mainAlias, String alias, String dateFormat, String dateTimeFormat, Locale locale) {
        List resultColumns = request.getResultColumns();
        List columnFilters = request.getColumnFilters();
        if ((resultColumns == null || resultColumns.isEmpty()) && (columnFilters == null || columnFilters.isEmpty())) {
            return false;
        }
        datatable = this.datatableUtil.validateDatatableRegistered(datatable);
        this.context.authenticatedUser().validateHasDatatableReadPermission(datatable);
        Map headersByName = this.searchUtil.mapHeadersToName((Collection)this.genericDataService.fillResultsetColumnHeaders(datatable));
        List thisSelectColumns = this.searchUtil.validateToJdbcColumnNames(resultColumns, headersByName, true);
        if (columnFilters != null) {
            columnFilters.forEach(e -> e.setColumn(this.searchUtil.validateToJdbcColumnName(e.getColumn(), headersByName, false)));
        }
        select.append(this.sqlGenerator.buildSelect((Collection)thisSelectColumns, alias, true));
        selectColumns.addAll(thisSelectColumns);
        String joinType = "LEFT";
        if (this.searchUtil.buildQueryCondition(columnFilters, where, params, alias, headersByName, dateFormat, dateTimeFormat, locale, true, this.sqlGenerator)) {
            joinType = null;
        }
        from.append(this.sqlGenerator.buildJoin(datatable, alias, entityTable.getForeignKeyColumnNameOnDatatable(), mainAlias, entityTable.getRefColumn(), joinType));
        return true;
    }

    @Transactional(readOnly=true)
    public GenericResultsetData retrieveDataTableGenericResultSet(String dataTableName, Long appTableId, String order, Long id) {
        EntityTables entityTable = this.datatableUtil.queryForApplicationEntity(dataTableName);
        this.datatableUtil.checkMainResourceExistsWithinScope(entityTable, appTableId);
        return this.datatableUtil.retrieveDataTableGenericResultSet(entityTable, dataTableName, appTableId, order, id);
    }

    public Long countDatatableEntries(String datatableName, Long appTableId, String foreignKeyColumn) {
        String sqlString = "SELECT COUNT(" + this.sqlGenerator.escape(foreignKeyColumn) + ") FROM " + this.sqlGenerator.escape(datatableName) + " WHERE " + this.sqlGenerator.escape(foreignKeyColumn) + " = " + appTableId;
        return (Long)this.jdbcTemplate.queryForObject(sqlString, Long.class);
    }

    public String getDataTableName(String url) {
        List urlParts = Splitter.on((char)'/').splitToList((CharSequence)url);
        return (String)urlParts.get(3);
    }

    public String getTableName(String url) {
        List urlParts = Splitter.on((char)'/').splitToList((CharSequence)url);
        return (String)urlParts.get(4);
    }

    @Generated
    public DatatableReadServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext context, GenericDataService genericDataService, DataTableValidator dataTableValidator, SqlValidator sqlValidator, SearchUtil searchUtil, DatatableUtil datatableUtil) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.context = context;
        this.genericDataService = genericDataService;
        this.dataTableValidator = dataTableValidator;
        this.sqlValidator = sqlValidator;
        this.searchUtil = searchUtil;
        this.datatableUtil = datatableUtil;
    }
}

