/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.provisioning.domain;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fineract.accounting.glaccount.domain.GLAccount;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractAuditableCustom;
import org.apache.fineract.organisation.provisioning.data.ProvisioningCriteriaDefinitionData;
import org.apache.fineract.organisation.provisioning.domain.LoanProductProvisionCriteria;
import org.apache.fineract.organisation.provisioning.domain.ProvisioningCriteriaDefinition;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.useradministration.domain.AppUser;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

@Entity
@Table(name="m_provisioning_criteria", uniqueConstraints={@UniqueConstraint(columnNames={"criteria_name"}, name="criteria_name")})
public class ProvisioningCriteria
extends AbstractAuditableCustom
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups {
    @Column(name="criteria_name", nullable=false)
    private String criteriaName;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="criteria", orphanRemoval=true, fetch=FetchType.EAGER)
    Set<ProvisioningCriteriaDefinition> provisioningCriteriaDefinition;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="criteria", orphanRemoval=true, fetch=FetchType.EAGER)
    Set<LoanProductProvisionCriteria> loanProductMapping;
    static final long serialVersionUID = 1019505380560356738L;

    public String getCriteriaName() {
        return this._persistence_get_criteriaName();
    }

    public void setCriteriaName(String criteriaName) {
        this._persistence_set_criteriaName(criteriaName);
    }

    protected ProvisioningCriteria() {
        this.provisioningCriteriaDefinition = new HashSet();
        this.loanProductMapping = new HashSet();
    }

    public ProvisioningCriteria(String criteriaName, AppUser createdBy, LocalDateTime createdDate, AppUser lastModifiedBy, LocalDateTime lastModifiedDate) {
        this.provisioningCriteriaDefinition = new HashSet();
        this.loanProductMapping = new HashSet();
        this.criteriaName = criteriaName;
        this.setCreatedBy((Long)createdBy.getId());
        this.setCreatedDate(createdDate);
        this.setLastModifiedBy((Long)lastModifiedBy.getId());
        this.setLastModifiedDate(lastModifiedDate);
    }

    public void setProvisioningCriteriaDefinitions(Set<ProvisioningCriteriaDefinition> provisioningCriteriaDefinition) {
        this._persistence_get_provisioningCriteriaDefinition().clear();
        this._persistence_get_provisioningCriteriaDefinition().addAll(provisioningCriteriaDefinition);
    }

    public void setLoanProductProvisioningCriteria(Set<LoanProductProvisionCriteria> loanProductMapping) {
        this._persistence_get_loanProductMapping().clear();
        this._persistence_get_loanProductMapping().addAll(loanProductMapping);
    }

    public Map<String, Object> update(JsonCommand command, List<LoanProduct> loanProducts) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(7);
        if (command.isChangeInStringParameterNamed("criteriaName", this._persistence_get_criteriaName())) {
            String valueAsInput = command.stringValueOfParameterNamed("criteriaName");
            actualChanges.put("criteriaName", valueAsInput);
            this._persistence_set_criteriaName(valueAsInput);
        }
        HashSet<LoanProductProvisionCriteria> temp = new HashSet<LoanProductProvisionCriteria>();
        HashSet<LoanProduct> productsTemp = new HashSet<LoanProduct>();
        for (LoanProductProvisionCriteria mapping : this._persistence_get_loanProductMapping()) {
            if (!loanProducts.contains(mapping.getLoanProduct())) {
                temp.add(mapping);
                continue;
            }
            productsTemp.add(mapping.getLoanProduct());
        }
        this._persistence_get_loanProductMapping().removeAll(temp);
        for (LoanProduct loanProduct : loanProducts) {
            if (productsTemp.contains(loanProduct)) continue;
            this._persistence_get_loanProductMapping().add(new LoanProductProvisionCriteria(this, loanProduct));
        }
        actualChanges.put("loanProducts", this._persistence_get_loanProductMapping());
        return actualChanges;
    }

    public void update(ProvisioningCriteriaDefinitionData data, GLAccount liability, GLAccount expense) {
        for (ProvisioningCriteriaDefinition def : this._persistence_get_provisioningCriteriaDefinition()) {
            if (!data.getId().equals(def.getId())) continue;
            def.update(data.getMinAge(), data.getMaxAge(), data.getProvisioningPercentage(), liability, expense);
            break;
        }
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProvisioningCriteria(persistenceObject);
    }

    public ProvisioningCriteria(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "loanProductMapping") {
            return this.loanProductMapping;
        }
        if (string == "criteriaName") {
            return this.criteriaName;
        }
        if (string == "provisioningCriteriaDefinition") {
            return this.provisioningCriteriaDefinition;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "loanProductMapping") {
            this.loanProductMapping = (Set)object;
            return;
        }
        if (string == "criteriaName") {
            this.criteriaName = (String)object;
            return;
        }
        if (string == "provisioningCriteriaDefinition") {
            this.provisioningCriteriaDefinition = (Set)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public Set _persistence_get_loanProductMapping() {
        this._persistence_checkFetched("loanProductMapping");
        return this.loanProductMapping;
    }

    public void _persistence_set_loanProductMapping(Set set) {
        this._persistence_checkFetchedForSet("loanProductMapping");
        this.loanProductMapping = set;
    }

    public String _persistence_get_criteriaName() {
        this._persistence_checkFetched("criteriaName");
        return this.criteriaName;
    }

    public void _persistence_set_criteriaName(String string) {
        this._persistence_checkFetchedForSet("criteriaName");
        this.criteriaName = string;
    }

    public Set _persistence_get_provisioningCriteriaDefinition() {
        this._persistence_checkFetched("provisioningCriteriaDefinition");
        return this.provisioningCriteriaDefinition;
    }

    public void _persistence_set_provisioningCriteriaDefinition(Set set) {
        this._persistence_checkFetchedForSet("provisioningCriteriaDefinition");
        this.provisioningCriteriaDefinition = set;
    }
}

