/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.staff.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class StaffCommandFromApiJsonDeserializer {
    public static final String FIRSTNAME = "firstname";
    public static final String LASTNAME = "lastname";
    public static final String OFFICE_ID = "officeId";
    public static final String EXTERNAL_ID = "externalId";
    public static final String MOBILE_NO = "mobileNo";
    public static final String IS_LOAN_OFFICER = "isLoanOfficer";
    public static final String IS_ACTIVE = "isActive";
    public static final String JOINING_DATE = "joiningDate";
    public static final String DATE_FORMAT = "dateFormat";
    public static final String LOCALE = "locale";
    public static final String FORCE_STATUS = "forceStatus";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("firstname", "lastname", "officeId", "externalId", "mobileNo", "isLoanOfficer", "isActive", "joiningDate", "dateFormat", "locale", "forceStatus"));
    private final FromJsonHelper fromApiJsonHelper;
    private final StaffReadPlatformService staffReadPlatformService;

    @Autowired
    public StaffCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper, StaffReadPlatformService staffReadPlatformService) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.staffReadPlatformService = staffReadPlatformService;
    }

    public void validateForCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("staff");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        Long officeId = this.fromApiJsonHelper.extractLongNamed(OFFICE_ID, element);
        baseDataValidator.reset().parameter(OFFICE_ID).value((Object)officeId).notNull().integerGreaterThanZero();
        String firstname = this.fromApiJsonHelper.extractStringNamed(FIRSTNAME, element);
        baseDataValidator.reset().parameter(FIRSTNAME).value((Object)firstname).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        String lastname = this.fromApiJsonHelper.extractStringNamed(LASTNAME, element);
        baseDataValidator.reset().parameter(LASTNAME).value((Object)lastname).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        if (this.fromApiJsonHelper.parameterExists(MOBILE_NO, element)) {
            String mobileNo = this.fromApiJsonHelper.extractStringNamed(MOBILE_NO, element);
            baseDataValidator.reset().parameter(MOBILE_NO).value((Object)mobileNo).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists(IS_LOAN_OFFICER, element)) {
            String loanOfficerFlag = this.fromApiJsonHelper.extractStringNamed(IS_LOAN_OFFICER, element);
            baseDataValidator.reset().parameter(IS_LOAN_OFFICER).trueOrFalseRequired((Object)loanOfficerFlag);
        }
        if (this.fromApiJsonHelper.parameterExists(IS_ACTIVE, element)) {
            String activeFlag = this.fromApiJsonHelper.extractStringNamed(IS_ACTIVE, element);
            baseDataValidator.reset().parameter(IS_ACTIVE).trueOrFalseRequired((Object)activeFlag);
        }
        LocalDate joiningDate = this.fromApiJsonHelper.extractLocalDateNamed(JOINING_DATE, element);
        baseDataValidator.reset().parameter(JOINING_DATE).value((Object)joiningDate).notNull();
        if (this.fromApiJsonHelper.parameterExists(DATE_FORMAT, element)) {
            String dateFormat = this.fromApiJsonHelper.extractStringNamed(DATE_FORMAT, element);
            baseDataValidator.reset().parameter(DATE_FORMAT).value((Object)dateFormat).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists(LOCALE, element)) {
            String locale = this.fromApiJsonHelper.extractStringNamed(LOCALE, element);
            baseDataValidator.reset().parameter(LOCALE).value((Object)locale).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists(EXTERNAL_ID, element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed(EXTERNAL_ID, element);
            baseDataValidator.reset().parameter(EXTERNAL_ID).value((Object)externalId).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        this.validateForUpdate(json, null);
    }

    public void validateForUpdate(String json, Long staffId) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("staff");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists(OFFICE_ID, element)) {
            Long officeId = this.fromApiJsonHelper.extractLongNamed(OFFICE_ID, element);
            baseDataValidator.reset().parameter(OFFICE_ID).value((Object)officeId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists(FIRSTNAME, element)) {
            String firstname = this.fromApiJsonHelper.extractStringNamed(FIRSTNAME, element);
            baseDataValidator.reset().parameter(FIRSTNAME).value((Object)firstname).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists(LASTNAME, element)) {
            String lastname = this.fromApiJsonHelper.extractStringNamed(LASTNAME, element);
            baseDataValidator.reset().parameter(LASTNAME).value((Object)lastname).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists(MOBILE_NO, element)) {
            String mobileNo = this.fromApiJsonHelper.extractStringNamed(MOBILE_NO, element);
            baseDataValidator.reset().parameter(MOBILE_NO).value((Object)mobileNo).notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists(IS_LOAN_OFFICER, element)) {
            String loanOfficerFlag = this.fromApiJsonHelper.extractStringNamed(IS_LOAN_OFFICER, element);
            baseDataValidator.reset().parameter(IS_LOAN_OFFICER).trueOrFalseRequired((Object)loanOfficerFlag);
        }
        if (this.fromApiJsonHelper.parameterExists(IS_ACTIVE, element)) {
            Object[] result;
            String activeFlagStr = this.fromApiJsonHelper.extractStringNamed(IS_ACTIVE, element);
            baseDataValidator.reset().parameter(IS_ACTIVE).trueOrFalseRequired((Object)activeFlagStr);
            Boolean activeFlag = this.fromApiJsonHelper.extractBooleanNamed(IS_ACTIVE, element);
            Boolean forceStatus = this.fromApiJsonHelper.extractBooleanNamed(FORCE_STATUS, element);
            if ((!activeFlag.booleanValue() && forceStatus == null || !activeFlag.booleanValue() && forceStatus.booleanValue()) && (result = this.staffReadPlatformService.hasAssociatedItems(staffId)) != null && result.length > 0) {
                baseDataValidator.reset().parameter("isactive").failWithCode("staff.is.assigned", result);
            }
            baseDataValidator.reset().parameter(IS_ACTIVE).value((Object)activeFlag).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(JOINING_DATE, element)) {
            LocalDate joiningDate = this.fromApiJsonHelper.extractLocalDateNamed(JOINING_DATE, element);
            baseDataValidator.reset().parameter(JOINING_DATE).value((Object)joiningDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists(DATE_FORMAT, element)) {
            String dateFormat = this.fromApiJsonHelper.extractStringNamed(DATE_FORMAT, element);
            baseDataValidator.reset().parameter(DATE_FORMAT).value((Object)dateFormat).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists(LOCALE, element)) {
            String locale = this.fromApiJsonHelper.extractStringNamed(LOCALE, element);
            baseDataValidator.reset().parameter(LOCALE).value((Object)locale).notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists(EXTERNAL_ID, element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed(EXTERNAL_ID, element);
            baseDataValidator.reset().parameter(EXTERNAL_ID).value((Object)externalId).notBlank().notExceedingLengthOf(Integer.valueOf(100));
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

